/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
public class PermanentBlobCacheTest {
    @Test
    public void permanentBlobCacheCanServeFilesFromPrepopulatedStorageDirectory(@TempDir Path storageDirectory) throws IOException {
        JobID jobId = new JobID();
        byte[] fileContent = "foobar".getBytes(StandardCharsets.UTF_8);
        PermanentBlobKey blobKey = TestingBlobUtils.writePermanentBlob(storageDirectory, jobId, fileContent);
        try (PermanentBlobCache permanentBlobCache = new PermanentBlobCache(new Configuration(), storageDirectory.toFile(), (BlobView)new VoidBlobStore(), null);){
            File blob = permanentBlobCache.getFile(jobId, blobKey);
            Assertions.assertThat((byte[])Files.readAllBytes(blob.toPath())).isEqualTo((Object)fileContent);
        }
    }

    @Test
    public void permanentBlobCacheChecksForCorruptedBlobsAtStart(@TempDir Path storageDirectory) throws IOException {
        JobID jobId = new JobID();
        PermanentBlobKey blobKey = TestingBlobUtils.writePermanentBlob(storageDirectory, jobId, new byte[]{1, 2, 3, 4});
        File blobFile = new File(BlobUtils.getStorageLocationPath((String)storageDirectory.toString(), (JobID)jobId, (BlobKey)blobKey));
        FileUtils.writeByteArrayToFile((File)blobFile, (byte[])new byte[]{4, 3, 2, 1});
        try (PermanentBlobCache permanentBlobCache = new PermanentBlobCache(new Configuration(), storageDirectory.toFile(), (BlobView)new VoidBlobStore(), null);){
            Assertions.assertThatThrownBy(() -> permanentBlobCache.getFile(jobId, blobKey)).isInstanceOf(IOException.class);
        }
    }

    @Test
    public void permanentBlobCacheTimesOutRecoveredBlobs(@TempDir Path storageDirectory) throws Exception {
        JobID jobId = new JobID();
        PermanentBlobKey permanentBlobKey = TestingBlobUtils.writePermanentBlob(storageDirectory, jobId, new byte[]{1, 2, 3, 4});
        File blobFile = BlobUtils.getStorageLocation((File)storageDirectory.toFile(), (JobID)jobId, (BlobKey)permanentBlobKey);
        Configuration configuration = new Configuration();
        long cleanupInterval = 1L;
        configuration.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)1L);
        try (PermanentBlobCache permanentBlobCache = new PermanentBlobCache(configuration, storageDirectory.toFile(), (BlobView)new VoidBlobStore(), null);){
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> !blobFile.exists()));
        }
    }
}

