/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.json.JobIDSerializer;
import org.apache.flink.runtime.rest.messages.json.SerializedThrowableSerializer;
import org.apache.flink.runtime.rest.messages.json.SerializedValueSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;

public class JobResultSerializer
extends StdSerializer<JobResult> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_JOB_ID = "id";
    static final String FIELD_NAME_APPLICATION_STATUS = "application-status";
    static final String FIELD_NAME_NET_RUNTIME = "net-runtime";
    static final String FIELD_NAME_ACCUMULATOR_RESULTS = "accumulator-results";
    static final String FIELD_NAME_FAILURE_CAUSE = "failure-cause";
    private final JobIDSerializer jobIdSerializer = new JobIDSerializer();
    private final SerializedValueSerializer serializedValueSerializer;
    private final SerializedThrowableSerializer serializedThrowableSerializer = new SerializedThrowableSerializer();

    public JobResultSerializer() {
        super(JobResult.class);
        JavaType objectSerializedValueType = TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<SerializedValue<Object>>(){});
        this.serializedValueSerializer = new SerializedValueSerializer(objectSerializedValueType);
    }

    public void serialize(JobResult result, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName(FIELD_NAME_JOB_ID);
        this.jobIdSerializer.serialize(result.getJobId(), gen, provider);
        gen.writeFieldName(FIELD_NAME_APPLICATION_STATUS);
        gen.writeString(result.getApplicationStatus().name());
        gen.writeFieldName(FIELD_NAME_ACCUMULATOR_RESULTS);
        gen.writeStartObject();
        Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults = result.getAccumulatorResults();
        for (Map.Entry<String, SerializedValue<OptionalFailure<Object>>> nameValue : accumulatorResults.entrySet()) {
            String name = nameValue.getKey();
            SerializedValue<OptionalFailure<Object>> value = nameValue.getValue();
            gen.writeFieldName(name);
            this.serializedValueSerializer.serialize(value, gen, provider);
        }
        gen.writeEndObject();
        gen.writeNumberField(FIELD_NAME_NET_RUNTIME, result.getNetRuntime());
        if (result.getSerializedThrowable().isPresent()) {
            gen.writeFieldName(FIELD_NAME_FAILURE_CAUSE);
            SerializedThrowable serializedThrowable = result.getSerializedThrowable().get();
            this.serializedThrowableSerializer.serialize(serializedThrowable, gen, provider);
        }
        gen.writeEndObject();
    }
}

