/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.MutableObjectIterator;

public class UnionWithTempOperator<T>
implements Driver<Function, T> {
    private static final int CACHED_INPUT = 0;
    private static final int STREAMED_INPUT = 1;
    private TaskContext<Function, T> taskContext;
    private volatile boolean running;

    @Override
    public void setup(TaskContext<Function, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public Class<Function> getStubType() {
        return null;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        Object record;
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        CountingCollector<T> output = new CountingCollector<T>(this.taskContext.getOutputCollector(), numRecordsOut);
        Object reuse = this.taskContext.getInputSerializer(1).getSerializer().createInstance();
        MutableObjectIterator input = this.taskContext.getInput(1);
        while (this.running && (record = input.next(reuse)) != null) {
            numRecordsIn.inc();
            output.collect(record);
        }
        MutableObjectIterator cache = this.taskContext.getInput(0);
        while (this.running && (record = cache.next(reuse)) != null) {
            numRecordsIn.inc();
            output.collect(record);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

