/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.LastStateConnectionStateListener;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.com.google.common.collect.Sets;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.CuratorEvent;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.CuratorEventType;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperCheckpointIDCounter
implements CheckpointIDCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperCheckpointIDCounter.class);
    private final CuratorFramework client;
    private final String counterPath;
    private final SharedCount sharedCount;
    private final LastStateConnectionStateListener connectionStateListener;
    private final Object startStopLock = new Object();
    @GuardedBy(value="startStopLock")
    private boolean isStarted;

    public ZooKeeperCheckpointIDCounter(CuratorFramework client, LastStateConnectionStateListener connectionStateListener) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"Curator client");
        this.counterPath = ZooKeeperUtils.getCheckpointIdCounterPath();
        this.sharedCount = new SharedCount(client, this.counterPath, 1);
        this.connectionStateListener = connectionStateListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.isStarted) {
                this.sharedCount.start();
                this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
                this.isStarted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> shutdown(JobStatus jobStatus) {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.isStarted) {
                LOG.info("Shutting down.");
                try {
                    this.sharedCount.close();
                }
                catch (IOException e) {
                    return FutureUtils.completedExceptionally((Throwable)e);
                }
                this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
                if (jobStatus.isGloballyTerminalState()) {
                    LOG.info("Removing {} from ZooKeeper", (Object)this.counterPath);
                    try {
                        CompletableFuture<Void> deletionFuture = new CompletableFuture<Void>();
                        ((ErrorListenerPathable)this.client.delete().inBackground((curatorFramework, curatorEvent) -> this.handleDeletionOfCounterPath(curatorEvent, deletionFuture))).forPath(this.counterPath);
                        return deletionFuture;
                    }
                    catch (Exception e) {
                        return FutureUtils.completedExceptionally((Throwable)e);
                    }
                }
                this.isStarted = false;
            }
        }
        return FutureUtils.completedVoidFuture();
    }

    private void handleDeletionOfCounterPath(CuratorEvent curatorEvent, CompletableFuture<Void> deletionFuture) {
        Preconditions.checkArgument((curatorEvent.getType() == CuratorEventType.DELETE ? 1 : 0) != 0, (Object)("An unexpected CuratorEvent was monitored: " + curatorEvent.getType()));
        Preconditions.checkArgument((boolean)this.counterPath.endsWith(curatorEvent.getPath()), (Object)("An unexpected path was selected for deletion: " + curatorEvent.getPath()));
        KeeperException.Code eventCode = KeeperException.Code.get((int)curatorEvent.getResultCode());
        if (Sets.immutableEnumSet((Enum)KeeperException.Code.OK, (Enum[])new KeeperException.Code[]{KeeperException.Code.NONODE}).contains((Object)eventCode)) {
            deletionFuture.complete(null);
        } else {
            String namespacedCounterPath = ZooKeeperUtils.generateZookeeperPath(this.client.getNamespace(), this.counterPath);
            deletionFuture.completeExceptionally((Throwable)new FlinkException(String.format("An error occurred while shutting down the CheckpointIDCounter in path '%s'.", namespacedCounterPath), (Throwable)KeeperException.create((KeeperException.Code)eventCode, (String)namespacedCounterPath)));
        }
    }

    @Override
    public long getAndIncrement() throws Exception {
        int newCount;
        VersionedValue current;
        do {
            this.checkConnectionState();
            current = this.sharedCount.getVersionedValue();
            newCount = (Integer)current.getValue() + 1;
            if (newCount >= 0) continue;
            throw new Exception("Checkpoint counter overflow. ZooKeeper checkpoint counter only supports checkpoints Ids up to 2147483647");
        } while (!this.sharedCount.trySetCount(current, newCount));
        return ((Integer)current.getValue()).intValue();
    }

    @Override
    public long get() {
        this.checkConnectionState();
        return ((Integer)this.sharedCount.getVersionedValue().getValue()).intValue();
    }

    @Override
    public void setCount(long newId) throws Exception {
        this.checkConnectionState();
        if (newId > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ZooKeeper checkpoint counter only supports checkpoints Ids up to 2147483647, but given value is" + newId);
        }
        this.sharedCount.setCount((int)newId);
    }

    private void checkConnectionState() {
        Optional<ConnectionState> optionalLastState = this.connectionStateListener.getLastState();
        optionalLastState.ifPresent(lastState -> {
            if (lastState != ConnectionState.CONNECTED && lastState != ConnectionState.RECONNECTED) {
                throw new IllegalStateException("Connection state: " + lastState);
            }
        });
    }

    @VisibleForTesting
    String getPath() {
        return this.counterPath;
    }
}

