/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileStateBackendTest
extends StateBackendTestBase<FsStateBackend> {
    @Parameterized.Parameter
    public boolean useAsyncMode;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Parameterized.Parameters
    public static List<Boolean> modes() {
        return Arrays.asList(true, false);
    }

    @Override
    protected ConfigurableStateBackend getStateBackend() throws Exception {
        File checkpointPath = this.tempFolder.newFolder();
        return new FsStateBackend(checkpointPath.toURI(), this.useAsyncMode);
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    protected boolean supportsAsynchronousSnapshots() {
        return this.useAsyncMode;
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testMapStateRestoreWithWrongSerializers() {
    }

    @Override
    @Ignore
    @Test
    public void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

