/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingResultPartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.PipelinedResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.SortMergeResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.HsResultPartition;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResultPartitionFactoryTest
extends TestLogger {
    private static final String tempDir = EnvironmentInformation.getTemporaryFileDirectory();
    private static final int SEGMENT_SIZE = 64;
    private static FileChannelManager fileChannelManager;

    @BeforeClass
    public static void setUp() {
        fileChannelManager = new FileChannelManagerImpl(new String[]{tempDir}, "testing");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        fileChannelManager.close();
    }

    @Test
    public void testBoundedBlockingSubpartitionsCreated() {
        BoundedBlockingResultPartition resultPartition = (BoundedBlockingResultPartition)ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING);
        Arrays.stream(resultPartition.subpartitions).forEach(sp -> MatcherAssert.assertThat((Object)sp, (Matcher)CoreMatchers.instanceOf(BoundedBlockingSubpartition.class)));
    }

    @Test
    public void testPipelinedSubpartitionsCreated() {
        PipelinedResultPartition resultPartition = (PipelinedResultPartition)ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.PIPELINED);
        Arrays.stream(resultPartition.subpartitions).forEach(sp -> MatcherAssert.assertThat((Object)sp, (Matcher)CoreMatchers.instanceOf(PipelinedSubpartition.class)));
    }

    @Test
    public void testSortMergePartitionCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING, 1);
        Assert.assertTrue((boolean)(resultPartition instanceof SortMergeResultPartition));
    }

    @Test
    public void testHybridFullResultPartitionCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL);
        Assert.assertTrue((boolean)(resultPartition instanceof HsResultPartition));
    }

    @Test
    public void testHybridSelectiveResultPartitionCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE);
        Assert.assertTrue((boolean)(resultPartition instanceof HsResultPartition));
    }

    @Test
    public void testNoReleaseOnConsumptionForBoundedBlockingPartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING);
        resultPartition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)resultPartition.isReleased());
    }

    @Test
    public void testNoReleaseOnConsumptionForSortMergePartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING, 1);
        resultPartition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)resultPartition.isReleased());
    }

    @Test
    public void testNoReleaseOnConsumptionForHybridFullPartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL);
        resultPartition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)resultPartition.isReleased());
    }

    @Test
    public void testNoReleaseOnConsumptionForHybridSelectivePartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE);
        resultPartition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)resultPartition.isReleased());
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType) {
        return ResultPartitionFactoryTest.createResultPartition(partitionType, Integer.MAX_VALUE);
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType, int sortShuffleMinParallelism) {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartitionFactory factory = new ResultPartitionFactory(manager, fileChannelManager, (BufferPoolFactory)new NetworkBufferPool(1, 64), new BatchShuffleReadBufferPool(640L, 64), Executors.newSingleThreadScheduledExecutor(), BoundedBlockingSubpartitionType.AUTO, 1, 1, 64, false, "LZ4", Integer.MAX_VALUE, 10, sortShuffleMinParallelism, false, 0);
        ResultPartitionDeploymentDescriptor descriptor = new ResultPartitionDeploymentDescriptor(PartitionDescriptorBuilder.newBuilder().setPartitionType(partitionType).build(), (ShuffleDescriptor)NettyShuffleDescriptorBuilder.newBuilder().buildLocal(), 1);
        Assert.assertEquals((long)1L, (long)descriptor.getNumberOfSubpartitions());
        ResultPartition partition = factory.create("test", 0, descriptor);
        manager.registerResultPartition(partition);
        return partition;
    }
}

