/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;

public abstract class SlotSelectionStrategyTestBase
extends TestLogger {
    protected final ResourceProfile resourceProfile = ResourceProfile.fromResources((double)2.0, (int)1024);
    protected final ResourceProfile biggerResourceProfile = ResourceProfile.fromResources((double)3.0, (int)1024);
    protected final AllocationID aid1 = new AllocationID();
    protected final AllocationID aid2 = new AllocationID();
    protected final AllocationID aid3 = new AllocationID();
    protected final AllocationID aid4 = new AllocationID();
    protected final AllocationID aidX = new AllocationID();
    protected final TaskManagerLocation tml1 = new TaskManagerLocation(new ResourceID("tm-1"), InetAddress.getLoopbackAddress(), 42);
    protected final TaskManagerLocation tml2 = new TaskManagerLocation(new ResourceID("tm-2"), InetAddress.getLoopbackAddress(), 43);
    protected final TaskManagerLocation tml3 = new TaskManagerLocation(new ResourceID("tm-3"), InetAddress.getLoopbackAddress(), 44);
    protected final TaskManagerLocation tml4 = new TaskManagerLocation(new ResourceID("tm-4"), InetAddress.getLoopbackAddress(), 45);
    protected final TaskManagerLocation tmlX = new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46);
    protected final TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
    protected final SlotInfoWithUtilization slotInfo1 = SlotInfoWithUtilization.from((SlotInfo)new SimpleSlotContext(this.aid1, this.tml1, 1, this.taskManagerGateway, this.resourceProfile), (double)0.0);
    protected final SlotInfoWithUtilization slotInfo2 = SlotInfoWithUtilization.from((SlotInfo)new SimpleSlotContext(this.aid2, this.tml2, 2, this.taskManagerGateway, this.biggerResourceProfile), (double)0.0);
    protected final SlotInfoWithUtilization slotInfo3 = SlotInfoWithUtilization.from((SlotInfo)new SimpleSlotContext(this.aid3, this.tml3, 3, this.taskManagerGateway, this.resourceProfile), (double)0.0);
    protected final SlotInfoWithUtilization slotInfo4 = SlotInfoWithUtilization.from((SlotInfo)new SimpleSlotContext(this.aid4, this.tml4, 4, this.taskManagerGateway, this.resourceProfile), (double)0.0);
    protected final Set<SlotSelectionStrategy.SlotInfoAndResources> candidates = Collections.unmodifiableSet(this.createCandidates());
    protected final SlotSelectionStrategy selectionStrategy;

    public SlotSelectionStrategyTestBase(SlotSelectionStrategy slotSelectionStrategy) {
        this.selectionStrategy = slotSelectionStrategy;
    }

    private Set<SlotSelectionStrategy.SlotInfoAndResources> createCandidates() {
        HashSet<SlotSelectionStrategy.SlotInfoAndResources> candidates = new HashSet<SlotSelectionStrategy.SlotInfoAndResources>(4);
        candidates.add(SlotSelectionStrategy.SlotInfoAndResources.fromSingleSlot((SlotInfoWithUtilization)this.slotInfo1));
        candidates.add(SlotSelectionStrategy.SlotInfoAndResources.fromSingleSlot((SlotInfoWithUtilization)this.slotInfo2));
        candidates.add(SlotSelectionStrategy.SlotInfoAndResources.fromSingleSlot((SlotInfoWithUtilization)this.slotInfo3));
        candidates.add(SlotSelectionStrategy.SlotInfoAndResources.fromSingleSlot((SlotInfoWithUtilization)this.slotInfo4));
        return candidates;
    }

    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> runMatching(SlotProfile slotProfile) {
        return this.selectionStrategy.selectBestSlotForProfile(this.candidates, slotProfile);
    }
}

