/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerRequestUtils;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.handlers.AllowNonRestoredStateQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.SavepointPathQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.utils.JarHandlerUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava18.com.google.common.base.Strings;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;

public class JarRunHandler
extends AbstractRestHandler<DispatcherGateway, JarRunRequestBody, JarRunResponseBody, JarRunMessageParameters> {
    private final Path jarDir;
    private final Configuration configuration;
    private final Executor executor;

    public JarRunHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<JarRunRequestBody, JarRunResponseBody, JarRunMessageParameters> messageHeaders, Path jarDir, Configuration configuration, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.jarDir = Objects.requireNonNull(jarDir);
        this.configuration = Objects.requireNonNull(configuration);
        this.executor = Objects.requireNonNull(executor);
    }

    protected CompletableFuture<JarRunResponseBody> handleRequest(@Nonnull HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request, @Nonnull DispatcherGateway gateway) throws RestHandlerException {
        JarHandlerUtils.JarHandlerContext context = JarHandlerUtils.JarHandlerContext.fromRequest(request, this.jarDir, this.log);
        SavepointRestoreSettings savepointRestoreSettings = this.getSavepointRestoreSettings(request);
        CompletableFuture<JobGraph> jobGraphFuture = this.getJobGraphAsync(context, savepointRestoreSettings);
        CompletableFuture blobServerPortFuture = gateway.getBlobServerPort(this.timeout);
        CompletionStage jarUploadFuture = jobGraphFuture.thenCombine((CompletionStage)blobServerPortFuture, (jobGraph, blobServerPort) -> {
            InetSocketAddress address = new InetSocketAddress(gateway.getHostname(), (int)blobServerPort);
            try {
                ClientUtils.extractAndUploadJobGraphFiles((JobGraph)jobGraph, () -> new BlobClient(address, this.configuration));
            }
            catch (FlinkException e) {
                throw new CompletionException(e);
            }
            return jobGraph;
        });
        CompletionStage jobSubmissionFuture = ((CompletableFuture)jarUploadFuture).thenCompose(jobGraph -> {
            jobGraph.setAllowQueuedScheduling(true);
            return gateway.submitJob(jobGraph, this.timeout);
        });
        return ((CompletableFuture)((CompletableFuture)jobSubmissionFuture).thenCombine(jarUploadFuture, (ack, jobGraph) -> new JarRunResponseBody(jobGraph.getJobID()))).exceptionally(throwable -> {
            throw new CompletionException((Throwable)new RestHandlerException(throwable.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, throwable));
        });
    }

    private SavepointRestoreSettings getSavepointRestoreSettings(@Nonnull HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request) throws RestHandlerException {
        JarRunRequestBody requestBody = (JarRunRequestBody)request.getRequestBody();
        boolean allowNonRestoredState = (Boolean)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)requestBody.getAllowNonRestoredState(), () -> (Boolean)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, AllowNonRestoredStateQueryParameter.class), (Object)false, (Logger)this.log);
        String savepointPath = (String)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)Strings.emptyToNull((String)requestBody.getSavepointPath()), () -> Strings.emptyToNull((String)((String)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, SavepointPathQueryParameter.class))), null, (Logger)this.log);
        SavepointRestoreSettings savepointRestoreSettings = savepointPath != null ? SavepointRestoreSettings.forPath((String)savepointPath, (boolean)allowNonRestoredState) : SavepointRestoreSettings.none();
        return savepointRestoreSettings;
    }

    private CompletableFuture<JobGraph> getJobGraphAsync(JarHandlerUtils.JarHandlerContext context, SavepointRestoreSettings savepointRestoreSettings) {
        return CompletableFuture.supplyAsync(() -> {
            JobGraph jobGraph = context.toJobGraph(this.configuration);
            jobGraph.setSavepointRestoreSettings(savepointRestoreSettings);
            return jobGraph;
        }, this.executor);
    }
}

