/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.webmonitor.WebMonitorExtension;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarListHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarListHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;

public class WebSubmissionExtension
implements WebMonitorExtension {
    private final ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> webSubmissionHandlers = new ArrayList(5);

    public WebSubmissionExtension(Configuration configuration, CompletableFuture<String> restAddressFuture, GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Map<String, String> responseHeaders, Path jarDir, Executor executor, Time timeout) throws Exception {
        JarUploadHandler jarUploadHandler = new JarUploadHandler(restAddressFuture, leaderRetriever, timeout, responseHeaders, JarUploadHeaders.getInstance(), jarDir, executor);
        JarListHandler jarListHandler = new JarListHandler(restAddressFuture, leaderRetriever, timeout, responseHeaders, JarListHeaders.getInstance(), jarDir.toFile(), executor);
        JarRunHandler jarRunHandler = new JarRunHandler(restAddressFuture, leaderRetriever, timeout, responseHeaders, JarRunHeaders.getInstance(), jarDir, configuration, executor);
        JarDeleteHandler jarDeleteHandler = new JarDeleteHandler(restAddressFuture, leaderRetriever, timeout, responseHeaders, JarDeleteHeaders.getInstance(), jarDir, executor);
        JarPlanHandler jarPlanHandler = new JarPlanHandler(restAddressFuture, leaderRetriever, timeout, responseHeaders, JarPlanHeaders.getInstance(), jarDir, configuration, executor);
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarUploadHeaders.getInstance(), (Object)((Object)jarUploadHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarListHeaders.getInstance(), (Object)((Object)jarListHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarRunHeaders.getInstance(), (Object)((Object)jarRunHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarDeleteHeaders.getInstance(), (Object)((Object)jarDeleteHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarPlanHeaders.getInstance(), (Object)((Object)jarPlanHandler)));
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> getHandlers() {
        return this.webSubmissionHandlers;
    }
}

