/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.AbstractJsonDeserializationSchema;
import org.apache.flink.formats.json.JsonParserToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class JsonParserRowDataDeserializationSchema
extends AbstractJsonDeserializationSchema {
    private final JsonParserToRowDataConverters.JsonParserToRowDataConverter runtimeConverter;

    public JsonParserRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this(rowType, resultTypeInfo, failOnMissingField, ignoreParseErrors, timestampFormat, null);
    }

    public JsonParserRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat, @Nullable String[][] projectedFields) {
        super(rowType, resultTypeInfo, failOnMissingField, ignoreParseErrors, timestampFormat);
        this.runtimeConverter = new JsonParserToRowDataConverters(failOnMissingField, ignoreParseErrors, timestampFormat).createConverter(projectedFields, (RowType)Preconditions.checkNotNull((Object)rowType));
    }

    public RowData deserialize(byte[] message) throws IOException {
        RowData rowData;
        block12: {
            if (message == null || message.length == 0) {
                return null;
            }
            JsonParser root = this.objectMapper.getFactory().createParser(message);
            try {
                if (root.currentToken() == null) {
                    root.nextToken();
                }
                if (root.currentToken() != JsonToken.START_OBJECT) {
                    throw JsonMappingException.from((JsonParser)root, (String)"No content to map due to end-of-input");
                }
                rowData = (RowData)this.runtimeConverter.convert(root);
                if (root == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (this.ignoreParseErrors) {
                        return null;
                    }
                    throw new IOException(String.format("Failed to deserialize JSON '%s'.", new String(message)), t);
                }
            }
            root.close();
        }
        return rowData;
    }
}

