/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.window.context;

import java.util.Collection;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalMergingState;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class WindowTriggerContext<K, IN, W extends Window>
implements Trigger.OnMergeContext {
    private K key;
    private W window;
    private final AbstractStreamOperator<?> operator;
    private final InternalTimerService<W> internalTimerService;
    private final TypeSerializer<W> windowSerializer;
    private final Trigger<? super IN, ? super W> trigger;
    private Collection<W> mergedWindows;

    public WindowTriggerContext(K key, W window, AbstractStreamOperator<?> operator, InternalTimerService<W> internalTimerService, Trigger<? super IN, ? super W> trigger, TypeSerializer<W> windowSerializer) {
        this.key = key;
        this.window = window;
        this.operator = operator;
        this.internalTimerService = internalTimerService;
        this.trigger = trigger;
        this.windowSerializer = windowSerializer;
    }

    public MetricGroup getMetricGroup() {
        return this.operator.getMetricGroup();
    }

    public long getCurrentWatermark() {
        return this.internalTimerService.currentWatermark();
    }

    public <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) {
        try {
            return (S)this.operator.getPartitionedState(this.window, this.windowSerializer, stateDescriptor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve state", e);
        }
    }

    public <S extends MergingState<?, ?>> void mergePartitionedState(StateDescriptor<S, ?> stateDescriptor) {
        if (this.mergedWindows != null && !this.mergedWindows.isEmpty()) {
            try {
                MergingState rawState = (MergingState)this.operator.getKeyedStateBackend().getOrCreateKeyedState(this.windowSerializer, stateDescriptor);
                if (!(rawState instanceof InternalMergingState)) {
                    throw new IllegalArgumentException("The given state descriptor does not refer to a mergeable state (MergingState)");
                }
                InternalMergingState mergingState = (InternalMergingState)rawState;
                mergingState.mergeNamespaces(this.window, this.mergedWindows);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while merging state.", e);
            }
        }
    }

    public long getCurrentProcessingTime() {
        return this.internalTimerService.currentProcessingTime();
    }

    public void registerProcessingTimeTimer(long time) {
        this.internalTimerService.registerProcessingTimeTimer(this.window, time);
    }

    public void registerEventTimeTimer(long time) {
        this.internalTimerService.registerEventTimeTimer(this.window, time);
    }

    public void deleteProcessingTimeTimer(long time) {
        this.internalTimerService.deleteProcessingTimeTimer(this.window, time);
    }

    public void deleteEventTimeTimer(long time) {
        this.internalTimerService.deleteEventTimeTimer(this.window, time);
    }

    public TriggerResult onElement(StreamRecord<IN> element) throws Exception {
        return this.trigger.onElement(element.getValue(), element.getTimestamp(), this.window, (Trigger.TriggerContext)this);
    }

    public TriggerResult onProcessingTime(long time) throws Exception {
        return this.trigger.onProcessingTime(time, this.window, (Trigger.TriggerContext)this);
    }

    public TriggerResult onEventTime(long time) throws Exception {
        return this.trigger.onEventTime(time, this.window, (Trigger.TriggerContext)this);
    }

    public void onMerge(Collection<W> mergedWindows) throws Exception {
        this.mergedWindows = mergedWindows;
        this.trigger.onMerge(this.window, (Trigger.OnMergeContext)this);
    }

    public void clear() throws Exception {
        this.trigger.clear(this.window, (Trigger.TriggerContext)this);
    }

    public String toString() {
        return "WindowTriggerContext{key=" + this.key + ", window=" + this.window + "}";
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setWindow(W window) {
        this.window = window;
    }

    public K getKey() {
        return this.key;
    }

    public W getWindow() {
        return this.window;
    }
}

