/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.Resolver;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.Version;

public class FelixResolverState
implements Resolver.ResolverState {
    private final Logger m_logger;
    private final List m_moduleList = new ArrayList();
    private final Map m_fragmentMap = new HashMap();
    private final Map m_unresolvedPkgIndex = new HashMap();
    private final Map m_resolvedPkgIndex = new HashMap();
    private final Map m_resolvedCapMap = new HashMap();

    public FelixResolverState(Logger logger) {
        this.m_logger = logger;
    }

    public synchronized void addModule(IModule module) {
        if (Util.isFragment(module)) {
            this.addFragment(module);
        } else {
            this.addHost(module);
        }
    }

    public synchronized void removeModule(IModule module) {
        if (Util.isFragment(module)) {
            this.removeFragment(module);
        } else {
            this.removeHost(module);
        }
    }

    private void addFragment(IModule fragment) {
        IModule bestFragment = this.indexFragment(this.m_fragmentMap, fragment);
        if (bestFragment == fragment) {
            List matchingHosts = this.getMatchingHosts(fragment);
            for (int hostIdx = 0; hostIdx < matchingHosts.size(); ++hostIdx) {
                IModule host = ((ICapability)matchingHosts.get(hostIdx)).getModule();
                IModule[] fragments = ((ModuleImpl)host).getFragments();
                ArrayList<IModule> fragmentList = new ArrayList<IModule>();
                for (int fragIdx = 0; fragments != null && fragIdx < fragments.length; ++fragIdx) {
                    if (fragments[fragIdx].getSymbolicName().equals(bestFragment.getSymbolicName())) continue;
                    fragmentList.add(fragments[fragIdx]);
                }
                int index = -1;
                for (int listIdx = 0; index < 0 && listIdx < fragmentList.size(); ++listIdx) {
                    IModule f = (IModule)fragmentList.get(listIdx);
                    if (bestFragment.getBundle().getBundleId() >= f.getBundle().getBundleId()) continue;
                    index = listIdx;
                }
                fragmentList.add(index < 0 ? fragmentList.size() : index, bestFragment);
                ICapability[] caps = host.getCapabilities();
                for (int i = 0; caps != null && i < caps.length; ++i) {
                    String pkgName;
                    List capList;
                    if (!caps[i].getNamespace().equals("package") || (capList = (List)this.m_unresolvedPkgIndex.get(pkgName = (String)caps[i].getProperties().get("package"))) == null) continue;
                    capList.remove(caps[i]);
                }
                this.checkForConflicts(host, fragmentList);
                fragments = fragmentList.size() == 0 ? null : fragmentList.toArray(new IModule[fragmentList.size()]);
                try {
                    ((ModuleImpl)host).attachFragments(fragments);
                }
                catch (Exception ex) {
                    try {
                        ((ModuleImpl)host).attachFragments(null);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    this.m_logger.log(1, "Serious error attaching fragments.", ex);
                }
                caps = host.getCapabilities();
                for (int i = 0; caps != null && i < caps.length; ++i) {
                    if (!caps[i].getNamespace().equals("package")) continue;
                    this.indexPackageCapability(this.m_unresolvedPkgIndex, caps[i]);
                }
            }
        }
    }

    private void removeFragment(IModule fragment) {
        List fragList = (List)this.m_fragmentMap.get(fragment.getSymbolicName());
        if (fragList != null) {
            fragList.remove(fragment);
            if (fragList.size() == 0) {
                this.m_fragmentMap.remove(fragment.getSymbolicName());
            }
            List matchingHosts = this.getMatchingHosts(fragment);
            for (int hostIdx = 0; hostIdx < matchingHosts.size(); ++hostIdx) {
                IModule host = ((ICapability)matchingHosts.get(hostIdx)).getModule();
                IModule[] fragments = ((ModuleImpl)host).getFragments();
                for (int fragIdx = 0; fragments != null && fragIdx < fragments.length; ++fragIdx) {
                    int i;
                    if (fragments[fragIdx].equals(fragment)) continue;
                    List fragmentList = this.getMatchingFragments(host);
                    ICapability[] caps = host.getCapabilities();
                    for (i = 0; caps != null && i < caps.length; ++i) {
                        String pkgName;
                        List capList;
                        if (!caps[i].getNamespace().equals("package") || (capList = (List)this.m_unresolvedPkgIndex.get(pkgName = (String)caps[i].getProperties().get("package"))) == null) continue;
                        capList.remove(caps[i]);
                    }
                    this.checkForConflicts(host, fragmentList);
                    fragments = fragmentList.size() == 0 ? null : fragmentList.toArray(new IModule[fragmentList.size()]);
                    try {
                        ((ModuleImpl)host).attachFragments(fragments);
                    }
                    catch (Exception ex) {
                        try {
                            ((ModuleImpl)host).attachFragments(null);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        this.m_logger.log(1, "Serious error attaching fragments.", ex);
                    }
                    caps = host.getCapabilities();
                    for (i = 0; caps != null && i < caps.length; ++i) {
                        if (!caps[i].getNamespace().equals("package")) continue;
                        this.indexPackageCapability(this.m_unresolvedPkgIndex, caps[i]);
                    }
                }
            }
        }
    }

    private List getMatchingHosts(IModule fragment) {
        IRequirement hostReq = this.getFragmentHostRequirement(fragment);
        ArrayList<ICapability> matchingHosts = new ArrayList<ICapability>();
        for (int hostIdx = 0; hostReq != null && hostIdx < this.m_moduleList.size(); ++hostIdx) {
            ICapability hostCap;
            IModule host = (IModule)this.m_moduleList.get(hostIdx);
            if (host.isResolved() || ((BundleImpl)host.getBundle()).isStale() || ((BundleImpl)host.getBundle()).isRemovalPending() || (hostCap = Util.getSatisfyingCapability(host, hostReq)) == null) continue;
            matchingHosts.add(hostCap);
        }
        return matchingHosts;
    }

    private void checkForConflicts(IModule host, List fragmentList) {
        if (fragmentList == null || fragmentList.size() == 0) {
            return;
        }
        boolean MODULE_IDX = false;
        boolean REQ_IDX = true;
        HashMap<String, Object> ipMerged = new HashMap<String, Object>();
        HashMap<String, Object> rbMerged = new HashMap<String, Object>();
        IRequirement[] reqs = host.getRequirements();
        for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
            if (reqs[reqIdx].getNamespace().equals("package")) {
                ipMerged.put(((Requirement)reqs[reqIdx]).getTargetName(), new Object[]{host, reqs[reqIdx]});
                continue;
            }
            if (!reqs[reqIdx].getNamespace().equals("module")) continue;
            rbMerged.put(((Requirement)reqs[reqIdx]).getTargetName(), new Object[]{host, reqs[reqIdx]});
        }
        Iterator it = fragmentList.iterator();
        while (it.hasNext()) {
            Map.Entry entry;
            IModule fragment = (IModule)it.next();
            reqs = fragment.getRequirements();
            HashMap<String, Object[]> ipFragment = new HashMap<String, Object[]>();
            HashMap rbFragment = new HashMap();
            boolean conflicting = false;
            for (int reqIdx = 0; !conflicting && reqs != null && reqIdx < reqs.length; ++reqIdx) {
                if (!reqs[reqIdx].getNamespace().equals("package") && !reqs[reqIdx].getNamespace().equals("module")) continue;
                String targetName = ((Requirement)reqs[reqIdx]).getTargetName();
                HashMap<String, Object> mergedReqMap = reqs[reqIdx].getNamespace().equals("package") ? ipMerged : rbMerged;
                HashMap<String, Object[]> fragmentReqMap = reqs[reqIdx].getNamespace().equals("package") ? ipFragment : rbFragment;
                Object[] existing = (Object[])mergedReqMap.get(targetName);
                if (existing == null) {
                    fragmentReqMap.put(targetName, new Object[]{fragment, reqs[reqIdx]});
                } else if (this.isRequirementConflicting((Requirement)existing[1], (Requirement)reqs[reqIdx])) {
                    conflicting = true;
                }
                if (!conflicting) continue;
                ipFragment.clear();
                rbFragment.clear();
                it.remove();
                this.m_logger.log(4, "Excluding fragment " + fragment.getSymbolicName() + " from " + host.getSymbolicName() + " due to conflict with " + (reqs[reqIdx].getNamespace().equals("package") ? "imported package " : "required bundle ") + targetName + " from " + ((IModule)existing[0]).getSymbolicName());
            }
            Iterator it2 = ipFragment.entrySet().iterator();
            while (it2.hasNext()) {
                entry = it2.next();
                ipMerged.put((String)entry.getKey(), entry.getValue());
            }
            it2 = rbFragment.entrySet().iterator();
            while (it2.hasNext()) {
                entry = it2.next();
                rbMerged.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private boolean isRequirementConflicting(Requirement existing, Requirement additional) {
        int i;
        R4Attribute[] addAttrs;
        if (!existing.getNamespace().equals(additional.getNamespace())) {
            return false;
        }
        if (!existing.getTargetName().equals(additional.getTargetName())) {
            return false;
        }
        if (!existing.getTargetVersionRange().equals(additional.getTargetVersionRange())) {
            return true;
        }
        if (existing.isOptional() && existing.isOptional() != additional.isOptional()) {
            return true;
        }
        R4Directive[] exDirs = existing.getDirectives() == null ? new R4Directive[]{} : existing.getDirectives();
        HashMap<String, R4Directive> exDirMap = new HashMap<String, R4Directive>();
        for (int i2 = 0; i2 < exDirs.length; ++i2) {
            if (exDirs[i2].getName().equals("resolution")) continue;
            exDirMap.put(exDirs[i2].getName(), exDirs[i2]);
        }
        R4Directive[] addDirs = additional.getDirectives() == null ? new R4Directive[]{} : additional.getDirectives();
        HashMap<String, R4Directive> addDirMap = new HashMap<String, R4Directive>();
        for (int i3 = 0; i3 < addDirs.length; ++i3) {
            if (addDirs[i3].getName().equals("resolution")) continue;
            addDirMap.put(addDirs[i3].getName(), addDirs[i3]);
        }
        if (exDirMap.size() != addDirMap.size()) {
            return true;
        }
        Iterator it = addDirMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            R4Directive addDir = (R4Directive)entry.getValue();
            R4Directive exDir = (R4Directive)exDirMap.get(name);
            if (exDir != null && exDir.getValue().equals(addDir.getValue())) continue;
            return true;
        }
        R4Attribute[] exAttrs = existing.getAttributes() == null ? new R4Attribute[]{} : existing.getAttributes();
        R4Attribute[] r4AttributeArray = addAttrs = additional.getAttributes() == null ? new R4Attribute[]{} : additional.getAttributes();
        if (exAttrs.length != addAttrs.length) {
            return true;
        }
        HashMap<String, R4Attribute> exAttrMap = new HashMap<String, R4Attribute>();
        for (i = 0; i < exAttrs.length; ++i) {
            exAttrMap.put(exAttrs[i].getName(), exAttrs[i]);
        }
        for (i = 0; i < addAttrs.length; ++i) {
            R4Attribute exAttr = (R4Attribute)exAttrMap.get(addAttrs[i].getName());
            if (exAttr != null && exAttr.getValue().equals(addAttrs[i].getValue()) && exAttr.isMandatory() == addAttrs[i].isMandatory()) continue;
            return true;
        }
        return false;
    }

    private void addHost(IModule host) {
        this.m_moduleList.add(host);
        List fragmentList = this.getMatchingFragments(host);
        if (fragmentList.size() > 0) {
            this.checkForConflicts(host, fragmentList);
            IModule[] fragments = fragmentList.toArray(new IModule[fragmentList.size()]);
            try {
                ((ModuleImpl)host).attachFragments(fragments);
            }
            catch (Exception ex) {
                try {
                    ((ModuleImpl)host).attachFragments(null);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.m_logger.log(1, "Serious error attaching fragments.", ex);
            }
        }
        ICapability[] caps = host.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            this.indexPackageCapability(this.m_unresolvedPkgIndex, caps[i]);
        }
    }

    private void removeHost(IModule host) {
        this.m_moduleList.remove(host);
        ICapability[] caps = host.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[i].getProperties().get("package");
            List capList = (List)this.m_unresolvedPkgIndex.get(pkgName);
            if (capList != null) {
                capList.remove(caps[i]);
            }
            if ((capList = (List)this.m_resolvedPkgIndex.get(pkgName)) == null) continue;
            capList.remove(caps[i]);
        }
        this.m_resolvedCapMap.remove(host);
        try {
            ((ModuleImpl)host).attachFragments(null);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error detaching fragments.", ex);
        }
        ((ModuleImpl)host).setWires(null);
    }

    private List getMatchingFragments(IModule host) {
        ICapability[] caps = Util.getCapabilityByNamespace(host, "host");
        ICapability hostCap = caps.length == 0 ? null : caps[0];
        ArrayList<IModule> fragmentList = new ArrayList<IModule>();
        Iterator it = this.m_fragmentMap.entrySet().iterator();
        while (hostCap != null && it.hasNext()) {
            IRequirement hostReq;
            Map.Entry entry = it.next();
            List fragments = (List)entry.getValue();
            IModule fragment = null;
            for (int i = 0; fragment == null && i < fragments.size(); ++i) {
                IModule f = (IModule)fragments.get(i);
                if (((BundleImpl)f.getBundle()).isStale() || ((BundleImpl)f.getBundle()).isRemovalPending()) continue;
                fragment = f;
            }
            if (fragment == null || (hostReq = this.getFragmentHostRequirement(fragment)) == null || !hostReq.isSatisfied(hostCap)) continue;
            int index = -1;
            for (int listIdx = 0; index < 0 && listIdx < fragmentList.size(); ++listIdx) {
                IModule existing = (IModule)fragmentList.get(listIdx);
                if (fragment.getBundle().getBundleId() >= existing.getBundle().getBundleId()) continue;
                index = listIdx;
            }
            fragmentList.add(index < 0 ? fragmentList.size() : index, fragment);
        }
        return fragmentList;
    }

    public synchronized IModule findHost(IModule rootModule) throws ResolveException {
        IModule newRootModule = rootModule;
        if (Util.isFragment(rootModule)) {
            List matchingHosts = this.getMatchingHosts(rootModule);
            IModule currentBestHost = null;
            for (int hostIdx = 0; hostIdx < matchingHosts.size(); ++hostIdx) {
                IModule host = ((ICapability)matchingHosts.get(hostIdx)).getModule();
                if (currentBestHost == null) {
                    currentBestHost = host;
                    continue;
                }
                if (currentBestHost.getVersion().compareTo(host.getVersion()) >= 0) continue;
                currentBestHost = host;
            }
            newRootModule = currentBestHost;
            if (newRootModule == null) {
                throw new ResolveException("Unable to find host.", rootModule, this.getFragmentHostRequirement(rootModule));
            }
        }
        return newRootModule;
    }

    private IRequirement getFragmentHostRequirement(IModule fragment) {
        IRequirement[] reqs = fragment.getRequirements();
        IRequirement hostReq = null;
        for (int reqIdx = 0; hostReq == null && reqIdx < reqs.length; ++reqIdx) {
            if (!reqs[reqIdx].getNamespace().equals("host")) continue;
            hostReq = reqs[reqIdx];
        }
        return hostReq;
    }

    synchronized void refreshSystemBundleModule(IModule module) {
        ICapability[] caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            ArrayList<ICapability> resolvedCaps = (ArrayList<ICapability>)this.m_resolvedCapMap.get(module);
            if (resolvedCaps == null) {
                resolvedCaps = new ArrayList<ICapability>();
                this.m_resolvedCapMap.put(module, resolvedCaps);
            }
            if (!resolvedCaps.contains(caps[i])) {
                resolvedCaps.add(caps[i]);
            }
            if (!caps[i].getNamespace().equals("package")) continue;
            this.indexPackageCapability(this.m_resolvedPkgIndex, caps[i]);
        }
    }

    private void dumpPackageIndex(Map pkgIndex) {
        Iterator i = pkgIndex.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            List capList = (List)entry.getValue();
            if (capList.size() <= 0 || capList.size() == 1 && ((ICapability)capList.get(0)).getModule().getId().equals("0")) continue;
            System.out.println("  " + entry.getKey());
            for (int j = 0; j < capList.size(); ++j) {
                System.out.println("    " + ((ICapability)capList.get(j)).getModule());
            }
        }
    }

    public synchronized IModule[] getModules() {
        return this.m_moduleList.toArray(new IModule[this.m_moduleList.size()]);
    }

    public synchronized void moduleResolved(IModule module) {
        if (module.isResolved()) {
            int capIdx;
            ICapability[] capsCopy;
            ICapability[] caps = module.getCapabilities();
            for (int capIdx2 = 0; caps != null && capIdx2 < caps.length; ++capIdx2) {
                if (!caps[capIdx2].getNamespace().equals("package")) continue;
                String pkgName = (String)caps[capIdx2].getProperties().get("package");
                List capList = (List)this.m_unresolvedPkgIndex.get(pkgName);
                capList.remove(caps[capIdx2]);
            }
            ICapability[] iCapabilityArray = capsCopy = caps == null ? null : new ICapability[caps.length];
            if (capsCopy != null) {
                System.arraycopy(caps, 0, capsCopy, 0, caps.length);
            }
            IWire[] wires = module.getWires();
            block1: for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
                    if (!wires[wireIdx].getRequirement().isSatisfied(capsCopy[capIdx])) continue;
                    capsCopy[capIdx] = null;
                    continue block1;
                }
            }
            for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                if (capsCopy[capIdx] == null) continue;
                ArrayList<ICapability> resolvedCaps = (ArrayList<ICapability>)this.m_resolvedCapMap.get(module);
                if (resolvedCaps == null) {
                    resolvedCaps = new ArrayList<ICapability>();
                    this.m_resolvedCapMap.put(module, resolvedCaps);
                }
                if (!resolvedCaps.contains(capsCopy[capIdx])) {
                    resolvedCaps.add(capsCopy[capIdx]);
                }
                if (!capsCopy[capIdx].getNamespace().equals("package")) continue;
                this.indexPackageCapability(this.m_resolvedPkgIndex, capsCopy[capIdx]);
            }
        }
    }

    public synchronized List getResolvedCandidates(IRequirement req) {
        ArrayList<ICapability> candidates = new ArrayList<ICapability>();
        if (req.getNamespace().equals("package") && ((Requirement)req).getTargetName() != null) {
            String pkgName = ((Requirement)req).getTargetName();
            List capList = (List)this.m_resolvedPkgIndex.get(pkgName);
            for (int capIdx = 0; capList != null && capIdx < capList.size(); ++capIdx) {
                ICapability cap = (ICapability)capList.get(capIdx);
                if (!req.isSatisfied(cap)) continue;
                if (System.getSecurityManager() != null && !((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new PackagePermission(pkgName, "export"))) {
                    this.m_logger.log(4, "PackagePermission.EXPORT denied for " + pkgName + "from " + cap.getModule().getId());
                    continue;
                }
                candidates.add(cap);
            }
        } else {
            Iterator i = this.m_resolvedCapMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IModule module = (IModule)entry.getKey();
                List caps = (List)entry.getValue();
                for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                    ICapability cap = (ICapability)caps.get(capIdx);
                    if (!req.isSatisfied(cap)) continue;
                    if (cap.getNamespace().equals("package") && System.getSecurityManager() != null && !((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new PackagePermission((String)cap.getProperties().get("package"), "export"))) {
                        this.m_logger.log(4, "PackagePermission.EXPORT denied for " + cap.getProperties().get("package") + "from " + module.getId());
                        continue;
                    }
                    candidates.add(cap);
                }
            }
        }
        Collections.sort(candidates);
        return candidates;
    }

    public synchronized List getUnresolvedCandidates(IRequirement req) {
        ArrayList candidates = new ArrayList();
        if (req.getNamespace().equals("package") && ((Requirement)req).getTargetName() != null) {
            List capList = (List)this.m_unresolvedPkgIndex.get(((Requirement)req).getTargetName());
            for (int capIdx = 0; capList != null && capIdx < capList.size(); ++capIdx) {
                if (!req.isSatisfied((ICapability)capList.get(capIdx))) continue;
                candidates.add(capList.get(capIdx));
            }
        } else {
            IModule[] modules = this.getModules();
            for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
                ICapability cap = Util.getSatisfyingCapability(modules[modIdx], req);
                if (cap == null || modules[modIdx].isResolved()) continue;
                candidates.add(cap);
            }
        }
        Collections.sort(candidates);
        return candidates;
    }

    private void indexPackageCapability(Map map, ICapability capability) {
        if (capability.getNamespace().equals("package")) {
            String pkgName = (String)capability.getProperties().get("package");
            ArrayList<ICapability> capList = (ArrayList<ICapability>)map.get(pkgName);
            if (capList == null) {
                capList = new ArrayList<ICapability>();
                capList.add(capability);
            } else {
                Version version = (Version)capability.getProperties().get("version");
                Version middleVersion = null;
                int top = 0;
                int bottom = capList.size() - 1;
                int middle = 0;
                while (top <= bottom) {
                    middle = (bottom - top) / 2 + top;
                    middleVersion = (Version)((ICapability)capList.get(middle)).getProperties().get("version");
                    int cmp = middleVersion.compareTo(version);
                    if (cmp < 0) {
                        bottom = middle - 1;
                        continue;
                    }
                    if (cmp == 0) {
                        long exportId;
                        long middleId = ((ICapability)capList.get(middle)).getModule().getBundle().getBundleId();
                        if (middleId < (exportId = capability.getModule().getBundle().getBundleId())) {
                            top = middle + 1;
                            continue;
                        }
                        bottom = middle - 1;
                        continue;
                    }
                    top = middle + 1;
                }
                if (top >= capList.size() || capList.get(top) != capability) {
                    capList.add(top, capability);
                }
            }
            map.put(pkgName, capList);
        }
    }

    private IModule indexFragment(Map map, IModule module) {
        ArrayList<IModule> modules = (ArrayList<IModule>)map.get(module.getSymbolicName());
        if (modules == null) {
            modules = new ArrayList<IModule>();
            modules.add(module);
        } else {
            Version version = module.getVersion();
            Version middleVersion = null;
            int top = 0;
            int bottom = modules.size() - 1;
            int middle = 0;
            while (top <= bottom) {
                middle = (bottom - top) / 2 + top;
                middleVersion = ((IModule)modules.get(middle)).getVersion();
                int cmp = middleVersion.compareTo(version);
                if (cmp < 0) {
                    bottom = middle - 1;
                    continue;
                }
                if (cmp == 0) {
                    long exportId;
                    long middleId = ((IModule)modules.get(middle)).getBundle().getBundleId();
                    if (middleId < (exportId = module.getBundle().getBundleId())) {
                        top = middle + 1;
                        continue;
                    }
                    bottom = middle - 1;
                    continue;
                }
                top = middle + 1;
            }
            if (top >= modules.size() || modules.get(top) != module) {
                modules.add(top, module);
            }
        }
        map.put(module.getSymbolicName(), modules);
        return (IModule)modules.get(0);
    }
}

