/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.CallbackTypeDef;
import org.apache.felix.dm.impl.Configurable;
import org.apache.felix.dm.impl.ConfigurationEventImpl;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.metatype.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ConfigurationDependencyImpl
extends AbstractDependency<ConfigurationDependency>
implements ConfigurationDependency,
ManagedService {
    private volatile Dictionary<String, Object> m_settings;
    private volatile String m_pid;
    private ServiceRegistration m_registration;
    private volatile Class<?> m_configType;
    private volatile MetaTypeProviderImpl m_metaType;
    private final AtomicBoolean m_updateInvokedCache = new AtomicBoolean();
    private final Logger m_logger;
    private final BundleContext m_context;
    private volatile boolean m_needsInstance = true;

    public ConfigurationDependencyImpl() {
        this(null, null);
    }

    public ConfigurationDependencyImpl(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.setRequired(true);
        this.setCallback("updated");
    }

    public ConfigurationDependencyImpl(ConfigurationDependencyImpl prototype) {
        super(prototype);
        this.m_context = prototype.m_context;
        this.m_pid = prototype.m_pid;
        this.m_logger = prototype.m_logger;
        this.m_metaType = prototype.m_metaType != null ? new MetaTypeProviderImpl(prototype.m_metaType, this, null) : null;
        this.m_needsInstance = prototype.needsInstance();
        this.m_configType = prototype.m_configType;
    }

    @Override
    public Class<?> getAutoConfigType() {
        return null;
    }

    @Override
    public DependencyContext createCopy() {
        return new ConfigurationDependencyImpl(this);
    }

    @Override
    public ConfigurationDependencyImpl setCallback(String callback) {
        super.setCallbacks(callback, null);
        return this;
    }

    @Override
    public ConfigurationDependencyImpl setCallback(Object instance, String callback) {
        boolean needsInstantiatedComponent = instance == null;
        return this.setCallback(instance, callback, needsInstantiatedComponent);
    }

    @Override
    public ConfigurationDependencyImpl setCallback(Object instance, String callback, boolean needsInstance) {
        super.setCallbacks(instance, callback, null);
        this.m_needsInstance = needsInstance;
        return this;
    }

    @Override
    public ConfigurationDependency setCallback(String callback, Class<?> configType) {
        Objects.nonNull(configType);
        this.setCallback(callback);
        this.m_configType = configType;
        this.m_pid = this.m_pid == null ? configType.getName() : this.m_pid;
        return this;
    }

    @Override
    public ConfigurationDependency setCallback(Object instance, String callback, Class<?> configType) {
        Objects.nonNull(configType);
        this.setCallback(instance, callback);
        this.m_configType = configType;
        this.m_pid = this.m_pid == null ? configType.getName() : this.m_pid;
        return this;
    }

    @Override
    public ConfigurationDependencyImpl setCallback(Object instance, String callback, Class<?> configType, boolean needsInstance) {
        this.setCallback(instance, callback, needsInstance);
        this.m_configType = configType;
        return this;
    }

    @Override
    public boolean needsInstance() {
        return this.m_needsInstance;
    }

    @Override
    public void start() {
        BundleContext context = this.m_component.getBundleContext();
        if (context != null) {
            Properties props = new Properties();
            props.put("service.pid", this.m_pid);
            Object ms = this;
            if (this.m_metaType != null) {
                ms = this.m_metaType;
            }
            this.m_registration = context.registerService(ManagedService.class.getName(), ms, (Dictionary)props);
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.m_registration != null) {
            try {
                this.m_registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.m_registration = null;
        }
        super.stop();
    }

    @Override
    public ConfigurationDependency setPid(String pid) {
        this.ensureNotActive();
        this.m_pid = pid;
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.m_pid;
    }

    @Override
    public String getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "configuration";
    }

    @Override
    public ConfigurationDependency add(PropertyMetaData properties) {
        this.createMetaTypeImpl();
        this.m_metaType.add(properties);
        return this;
    }

    @Override
    public ConfigurationDependency setDescription(String description) {
        this.createMetaTypeImpl();
        this.m_metaType.setDescription(description);
        return this;
    }

    @Override
    public ConfigurationDependency setHeading(String heading) {
        this.createMetaTypeImpl();
        this.m_metaType.setName(heading);
        return this;
    }

    @Override
    public ConfigurationDependency setLocalization(String path) {
        this.createMetaTypeImpl();
        this.m_metaType.setLocalization(path);
        return this;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        if (this.m_settings == null) {
            throw new IllegalStateException("cannot find configuration");
        }
        return this.m_settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary settings) throws ConfigurationException {
        this.m_updateInvokedCache.set(false);
        Dictionary<String, Object> oldSettings = null;
        ConfigurationDependencyImpl configurationDependencyImpl = this;
        synchronized (configurationDependencyImpl) {
            oldSettings = this.m_settings;
        }
        if (oldSettings == null && settings == null) {
            return;
        }
        InvocationUtil.invokeUpdated(this.m_component.getExecutor(), () -> this.invokeUpdated(settings));
        this.m_settings = settings;
        if (oldSettings == null && settings != null) {
            this.m_component.handleEvent(this, EventType.ADDED, new ConfigurationEventImpl(this.m_pid, settings));
        } else if (oldSettings != null && settings != null) {
            this.m_component.handleEvent(this, EventType.CHANGED, new ConfigurationEventImpl(this.m_pid, settings));
        } else if (oldSettings != null && settings == null) {
            this.m_component.handleEvent(this, EventType.REMOVED, new ConfigurationEventImpl(this.m_pid, oldSettings));
        }
    }

    @Override
    public void invokeCallback(EventType type, Event ... event) {
        switch (type) {
            case ADDED: {
                try {
                    this.invokeUpdated(this.m_settings);
                }
                catch (Throwable err) {
                    this.logConfigurationException(err);
                }
                break;
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                this.m_updateInvokedCache.set(false);
                break;
            }
        }
    }

    static CallbackTypeDef createCallbackType(Logger logger, Component service, Class<?> configType, Dictionary<?, ?> settings) {
        Class[][] sigs = new Class[][]{{Dictionary.class}, {Component.class, Dictionary.class}, new Class[0]};
        Object[][] args = new Object[][]{{settings}, {service, settings}, new Object[0]};
        if (configType != null) {
            try {
                Object configurable = settings != null ? Configurable.create(configType, settings) : null;
                logger.debug("Using configuration-type injecting using %s as possible configType.", configType.getSimpleName());
                sigs = new Class[][]{{Dictionary.class}, {Component.class, Dictionary.class}, {Component.class, configType}, {configType}, new Class[0]};
                args = new Object[][]{{settings}, {service, settings}, {service, configurable}, {configurable}, new Object[0]};
            }
            catch (Exception e) {
                logger.warn("Failed to create configurable for configuration type %s!", e, configType);
            }
        }
        return new CallbackTypeDef(sigs, args);
    }

    private void invokeUpdated(Dictionary<?, ?> settings) throws Exception {
        if (this.m_updateInvokedCache.compareAndSet(false, true)) {
            if (!super.isStarted()) {
                return;
            }
            Object mainComponentInstance = this.m_component.getInstance();
            if (mainComponentInstance instanceof AbstractDecorator) {
                return;
            }
            Object[] instances = super.getInstances();
            CallbackTypeDef callbackInfo = ConfigurationDependencyImpl.createCallbackType(this.m_logger, this.m_component, this.m_configType, settings);
            boolean callbackFound = false;
            int i = 0;
            while (i < instances.length) {
                try {
                    InvocationUtil.invokeCallbackMethod(instances[i], this.m_add, callbackInfo.m_sigs, callbackInfo.m_args);
                    callbackFound |= true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                ++i;
            }
            if (!callbackFound) {
                Object[] instanceClasses = (String[])Stream.of(instances).map(c -> c.getClass().getName()).toArray(String[]::new);
                this.m_logger.log(1, "\"" + this.m_add + "\" configuration callback not found in any of the component classes: " + Arrays.toString(instanceClasses));
            }
        }
    }

    private synchronized void createMetaTypeImpl() {
        if (this.m_metaType == null) {
            this.m_metaType = new MetaTypeProviderImpl(this.m_pid, this.m_context, this.m_logger, this, null);
        }
    }

    private void logConfigurationException(Throwable err) {
        this.m_logger.log(1, "Got exception while handling configuration update for pid " + this.m_pid, err);
    }
}

