/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterComponent;
import org.apache.felix.dm.impl.ServiceDependencyImpl;
import org.apache.felix.dm.impl.ServiceEventImpl;
import org.osgi.framework.ServiceReference;

public class AspectServiceImpl
extends FilterComponent {
    private final String m_add;
    private final String m_change;
    private final String m_remove;
    private final String m_swap;
    private final int m_ranking;
    private final Object m_dependencyCallbackInstance;

    public AspectServiceImpl(DependencyManager dm, Class<?> aspectInterface, String aspectFilter, int ranking, String autoConfig, Object callbackInstance, String add, String change, String remove, String swap) {
        super(dm.createComponent());
        this.m_ranking = ranking;
        this.m_add = add;
        this.m_change = change;
        this.m_remove = remove;
        this.m_swap = swap;
        this.m_dependencyCallbackInstance = callbackInstance;
        this.m_component.setImplementation(new AspectImpl(aspectInterface, autoConfig)).add(dm.createServiceDependency().setService(aspectInterface, this.createDependencyFilterForAspect(aspectFilter)).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    private String createDependencyFilterForAspect(String aspectFilter) {
        if (aspectFilter == null || aspectFilter.length() == 0) {
            return "(!(org.apache.felix.dependencymanager.aspect=*))";
        }
        return "(&(!(org.apache.felix.dependencymanager.aspect=*))" + aspectFilter + ")";
    }

    private Hashtable<String, Object> getServiceProperties(ServiceReference ref) {
        String key;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] keys = ref.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            key = keys[i];
            if (!(key.equals("service.id") || key.equals("service.ranking") || key.equals("org.apache.felix.dependencymanager.aspect") || key.equals("objectClass"))) {
                props.put(key, ref.getProperty(key));
            }
            ++i;
        }
        if (this.m_serviceProperties != null) {
            Enumeration e = this.m_serviceProperties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                props.put(key, this.m_serviceProperties.get(key));
            }
        }
        props.put("org.apache.felix.dependencymanager.aspect", ref.getProperty("service.id"));
        props.put("service.ranking", this.m_ranking);
        return props;
    }

    class AspectImpl
    extends AbstractDecorator {
        private final Class<?> m_aspectInterface;
        private final String m_autoConfig;

        public AspectImpl(Class<?> aspectInterface, String autoConfig) {
            this.m_aspectInterface = aspectInterface;
            this.m_autoConfig = autoConfig;
        }

        @Override
        public Component createService(Object[] params) {
            ServiceReference ref = (ServiceReference)params[0];
            List<DependencyContext> dependencies = AspectServiceImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            Hashtable serviceProperties = AspectServiceImpl.this.getServiceProperties(ref);
            String[] serviceInterfaces = this.getServiceInterfaces();
            ServiceDependencyImpl aspectDependency = (ServiceDependencyImpl)this.m_manager.createServiceDependency().setService(this.m_aspectInterface, this.createAspectFilter(ref)).setRequired(true);
            aspectDependency.setCallbacks(new CallbackProxy(aspectDependency, ref), AspectServiceImpl.this.m_add != null ? "addAspect" : null, "changeAspect", AspectServiceImpl.this.m_remove != null ? "removeAspect" : null, AspectServiceImpl.this.m_swap != null ? "swapAspect" : null);
            if (this.m_autoConfig != null) {
                aspectDependency.setAutoConfig(this.m_autoConfig);
            } else if (AspectServiceImpl.this.m_add == null && AspectServiceImpl.this.m_change == null && AspectServiceImpl.this.m_remove == null && AspectServiceImpl.this.m_swap == null) {
                aspectDependency.setAutoConfig(true);
            }
            Component service = this.m_manager.createComponent().setInterface(serviceInterfaces, serviceProperties).setImplementation(AspectServiceImpl.this.m_serviceImpl).setFactory(AspectServiceImpl.this.m_factory, AspectServiceImpl.this.m_factoryCreateMethod).setComposition(AspectServiceImpl.this.m_compositionInstance, AspectServiceImpl.this.m_compositionMethod).setCallbacks(AspectServiceImpl.this.m_callbackObject, AspectServiceImpl.this.m_init, AspectServiceImpl.this.m_start, AspectServiceImpl.this.m_stop, AspectServiceImpl.this.m_destroy).add(aspectDependency);
            this.configureAutoConfigState(service, AspectServiceImpl.this.m_component);
            AspectServiceImpl.this.copyDependencies(dependencies, service);
            int i = 0;
            while (i < AspectServiceImpl.this.m_stateListeners.size()) {
                service.add((ComponentStateListener)AspectServiceImpl.this.m_stateListeners.get(i));
                ++i;
            }
            return service;
        }

        @Override
        public void setServiceProperties(Dictionary<?, ?> props) {
            for (Map.Entry<Object, Component> e : super.getServices().entrySet()) {
                ServiceReference originalServiceRef = (ServiceReference)e.getKey();
                Component c = e.getValue();
                Hashtable newProps = AspectServiceImpl.this.getServiceProperties(originalServiceRef);
                c.setServiceProperties(newProps);
            }
        }

        private String[] getServiceInterfaces() {
            ArrayList<String> serviceNames = new ArrayList<String>();
            serviceNames.add(this.m_aspectInterface.getName());
            if (AspectServiceImpl.this.m_serviceInterfaces != null) {
                int i = 0;
                while (i < AspectServiceImpl.this.m_serviceInterfaces.length) {
                    if (!AspectServiceImpl.this.m_serviceInterfaces[i].equals(this.m_aspectInterface.getName())) {
                        serviceNames.add(AspectServiceImpl.this.m_serviceInterfaces[i]);
                    }
                    ++i;
                }
            }
            return serviceNames.toArray(new String[serviceNames.size()]);
        }

        private String createAspectFilter(ServiceReference ref) {
            Long sid = (Long)ref.getProperty("service.id");
            return "(&(|(!(service.ranking=*))(service.ranking<=" + (AspectServiceImpl.this.m_ranking - 1) + "))(|(" + "service.id" + "=" + sid + ")(" + "org.apache.felix.dependencymanager.aspect" + "=" + sid + ")))";
        }

        public String toString() {
            return "Aspect for " + this.m_aspectInterface.getName();
        }
    }

    class CallbackProxy {
        private final ServiceDependencyImpl m_aspectDependency;
        private final ServiceReference m_originalServiceRef;

        CallbackProxy(ServiceDependency aspectDependency, ServiceReference originalServiceRef) {
            this.m_aspectDependency = (ServiceDependencyImpl)aspectDependency;
            this.m_originalServiceRef = originalServiceRef;
        }

        private Object[] getDependencyCallbackInstance() {
            Object[] objectArray;
            if (AspectServiceImpl.this.m_dependencyCallbackInstance == null) {
                objectArray = this.m_aspectDependency.getComponentContext().getInstances();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = AspectServiceImpl.this.m_dependencyCallbackInstance;
            }
            return objectArray;
        }

        private void addAspect(Component c, ServiceReference ref, Object service) {
            ServiceEventImpl event = new ServiceEventImpl(ref, service);
            this.m_aspectDependency.invoke(AspectServiceImpl.this.m_add, event, this.getDependencyCallbackInstance());
        }

        private void changeAspect(Component c, ServiceReference ref, Object service) {
            if (AspectServiceImpl.this.m_change != null) {
                ServiceEventImpl event = new ServiceEventImpl(ref, service);
                this.m_aspectDependency.invoke(AspectServiceImpl.this.m_change, event, this.getDependencyCallbackInstance());
            }
            Hashtable props = AspectServiceImpl.this.getServiceProperties(this.m_originalServiceRef);
            c.setServiceProperties(props);
        }

        private void removeAspect(Component c, ServiceReference ref, Object service) {
            ServiceEventImpl event = new ServiceEventImpl(ref, service);
            this.m_aspectDependency.invoke(AspectServiceImpl.this.m_remove, event, this.getDependencyCallbackInstance());
        }

        private void swapAspect(Component c, ServiceReference prevRef, Object prev, ServiceReference currRef, Object curr) {
            Object[] instances = this.m_aspectDependency.getComponentContext().getInstances();
            this.m_aspectDependency.invokeSwap(AspectServiceImpl.this.m_swap, prevRef, prev, currRef, curr, this.getDependencyCallbackInstance());
        }

        public String toString() {
            return "CallbackProxy";
        }
    }
}

