/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.impl.index.BundleContextInterceptor;
import org.apache.felix.dm.impl.index.FilterIndexBundleContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistryCache
implements ServiceListener {
    private final List m_filterIndexList = new CopyOnWriteArrayList();
    private final BundleContext m_context;
    private final FilterIndexBundleContext m_filterIndexBundleContext;
    private final Map m_bundleContextInterceptorMap = new HashMap();
    private long m_currentVersion = 0L;
    private long m_arrayVersion = -1L;
    private BundleContextInterceptor[] m_interceptors = null;
    private ServiceRegistration m_registration;

    public ServiceRegistryCache(BundleContext context) {
        this.m_context = context;
        this.m_filterIndexBundleContext = new FilterIndexBundleContext(this.m_context);
    }

    public void open() {
        this.m_context.addServiceListener((ServiceListener)this);
    }

    public void close() {
        this.m_context.removeServiceListener((ServiceListener)this);
    }

    public void addFilterIndex(FilterIndex index) {
        this.m_filterIndexList.add(index);
        index.open(this.m_filterIndexBundleContext);
    }

    public void removeFilterIndex(FilterIndex index) {
        index.close();
        this.m_filterIndexList.remove(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        this.m_filterIndexBundleContext.serviceChanged(event);
        Map map = this.m_bundleContextInterceptorMap;
        synchronized (map) {
            if (this.m_currentVersion != this.m_arrayVersion) {
                this.m_interceptors = this.m_bundleContextInterceptorMap.values().toArray(new BundleContextInterceptor[this.m_bundleContextInterceptorMap.size()]);
                this.m_arrayVersion = this.m_currentVersion;
            }
        }
        this.serviceChangedForFilterIndices(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleContext createBundleContextInterceptor(BundleContext context) {
        Map map = this.m_bundleContextInterceptorMap;
        synchronized (map) {
            BundleContextInterceptor bundleContextInterceptor = (BundleContextInterceptor)this.m_bundleContextInterceptorMap.get(context);
            if (bundleContextInterceptor == null) {
                bundleContextInterceptor = new BundleContextInterceptor(this, context);
                this.m_bundleContextInterceptorMap.put(context, bundleContextInterceptor);
                ++this.m_currentVersion;
            }
            return bundleContextInterceptor;
        }
    }

    public FilterIndex hasFilterIndexFor(String clazz, String filter) {
        Iterator iterator = this.m_filterIndexList.iterator();
        while (iterator.hasNext()) {
            FilterIndex filterIndex = (FilterIndex)iterator.next();
            if (!filterIndex.isApplicable(clazz, filter)) continue;
            return filterIndex;
        }
        return null;
    }

    public void serviceChangedForFilterIndices(ServiceEvent event) {
        Iterator iterator = this.m_filterIndexList.iterator();
        while (iterator.hasNext()) {
            FilterIndex filterIndex = (FilterIndex)iterator.next();
            filterIndex.serviceChanged(event);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ServiceRegistryCache[");
        sb.append("FilterIndices: " + this.m_filterIndexList.size());
        sb.append(", BundleContexts intercepted: " + this.m_bundleContextInterceptorMap.size());
        sb.append("]");
        return sb.toString();
    }

    public List getFilterIndices() {
        return this.m_filterIndexList;
    }
}

