/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.ComponentImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FilterService
implements Component,
ComponentDeclaration {
    protected ComponentImpl m_component;
    protected List m_stateListeners = new ArrayList();
    protected String m_init = "init";
    protected String m_start = "start";
    protected String m_stop = "stop";
    protected String m_destroy = "destroy";
    protected Object m_callbackObject;
    protected Object m_compositionInstance;
    protected String m_compositionMethod;
    protected String[] m_serviceInterfaces;
    protected Object m_serviceImpl;
    protected Object m_factory;
    protected String m_factoryCreateMethod;
    protected Dictionary m_serviceProperties;

    public FilterService(Component service) {
        this.m_component = (ComponentImpl)service;
    }

    public Component add(Dependency dependency) {
        AbstractDecorator ad;
        this.m_component.add(dependency);
        if (!dependency.isRequired() && (ad = (AbstractDecorator)this.m_component.getService()) != null) {
            ad.addDependency(dependency);
        }
        return this;
    }

    public Component add(List dependencies) {
        this.m_component.add(dependencies);
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            if (!((Dependency)it.next()).isRequired()) continue;
            return this;
        }
        AbstractDecorator ad = (AbstractDecorator)this.m_component.getService();
        if (ad != null) {
            ad.addDependencies(dependencies);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ComponentStateListener listener) {
        FilterService filterService = this;
        synchronized (filterService) {
            this.m_stateListeners.add(listener);
        }
        AbstractDecorator ad = (AbstractDecorator)this.m_component.getService();
        if (ad != null) {
            ad.addStateListener(listener);
        }
    }

    public List getDependencies() {
        return this.m_component.getDependencies();
    }

    public Object getService() {
        return this.m_component.getService();
    }

    public String getClassName() {
        return this.m_component.getClassName();
    }

    public synchronized Dictionary getServiceProperties() {
        return this.m_serviceProperties;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_component.getServiceRegistration();
    }

    public Component remove(Dependency dependency) {
        AbstractDecorator ad;
        this.m_component.remove(dependency);
        if (!dependency.isRequired() && (ad = (AbstractDecorator)this.m_component.getService()) != null) {
            ad.removeDependency(dependency);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ComponentStateListener listener) {
        FilterService filterService = this;
        synchronized (filterService) {
            this.m_stateListeners.remove(listener);
        }
        AbstractDecorator ad = (AbstractDecorator)this.m_component.getService();
        if (ad != null) {
            ad.removeStateListener(listener);
        }
    }

    public synchronized Component setCallbacks(Object instance, String init, String start, String stop, String destroy) {
        this.m_component.ensureNotActive();
        this.m_callbackObject = instance;
        this.m_init = init;
        this.m_start = start;
        this.m_stop = stop;
        this.m_destroy = destroy;
        return this;
    }

    public Component setCallbacks(String init, String start, String stop, String destroy) {
        this.setCallbacks(null, init, start, stop, destroy);
        return this;
    }

    public synchronized Component setComposition(Object instance, String getMethod) {
        this.m_component.ensureNotActive();
        this.m_compositionInstance = instance;
        this.m_compositionMethod = getMethod;
        return this;
    }

    public synchronized Component setComposition(String getMethod) {
        this.m_component.ensureNotActive();
        this.m_compositionMethod = getMethod;
        return this;
    }

    public synchronized Component setFactory(Object factory, String createMethod) {
        this.m_component.ensureNotActive();
        this.m_factory = factory;
        this.m_factoryCreateMethod = createMethod;
        return this;
    }

    public Component setFactory(String createMethod) {
        return this.setFactory(null, createMethod);
    }

    public synchronized Component setImplementation(Object implementation) {
        this.m_component.ensureNotActive();
        this.m_serviceImpl = implementation;
        return this;
    }

    public Component setInterface(String serviceName, Dictionary properties) {
        return this.setInterface(new String[]{serviceName}, properties);
    }

    public synchronized Component setInterface(String[] serviceInterfaces, Dictionary properties) {
        this.m_component.ensureNotActive();
        if (serviceInterfaces != null) {
            this.m_serviceInterfaces = new String[serviceInterfaces.length];
            System.arraycopy(serviceInterfaces, 0, this.m_serviceInterfaces, 0, serviceInterfaces.length);
            this.m_serviceProperties = properties;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component setServiceProperties(Dictionary serviceProperties) {
        AbstractDecorator ad;
        FilterService filterService = this;
        synchronized (filterService) {
            this.m_serviceProperties = serviceProperties;
        }
        if (serviceProperties != null && (ad = (AbstractDecorator)this.m_component.getService()) != null) {
            ad.setServiceProperties(serviceProperties);
        }
        return this;
    }

    public void start() {
        this.m_component.start();
    }

    public void stop() {
        this.m_component.stop();
    }

    public void invokeCallbackMethod(Object[] instances, String methodName, Class[][] signatures, Object[][] parameters) {
        this.m_component.invokeCallbackMethod(instances, methodName, signatures, parameters);
    }

    public Object[] getCompositionInstances() {
        return this.m_component.getCompositionInstances();
    }

    public DependencyManager getDependencyManager() {
        return this.m_component.getDependencyManager();
    }

    public Component setAutoConfig(Class clazz, boolean autoConfig) {
        this.m_component.setAutoConfig(clazz, autoConfig);
        return this;
    }

    public Component setAutoConfig(Class clazz, String instanceName) {
        this.m_component.setAutoConfig(clazz, instanceName);
        return this;
    }

    public boolean getAutoConfig(Class clazz) {
        return this.m_component.getAutoConfig(clazz);
    }

    public String getAutoConfigInstance(Class clazz) {
        return this.m_component.getAutoConfigInstance(clazz);
    }

    public ComponentDependencyDeclaration[] getComponentDependencies() {
        return this.m_component.getComponentDependencies();
    }

    public String getName() {
        return this.m_component.getName();
    }

    public int getState() {
        return this.m_component.getState();
    }

    public long getId() {
        return this.m_component.getId();
    }

    public String[] getServices() {
        return this.m_component.getServices();
    }

    public BundleContext getBundleContext() {
        return this.m_component.getBundleContext();
    }
}

