/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.util.converter.ConvertingImpl;
import org.osgi.util.converter.DynamicBeanFacade;
import org.osgi.util.converter.DynamicDTOFacade;
import org.osgi.util.converter.DynamicDictionaryFacade;
import org.osgi.util.converter.DynamicInterfaceFacade;
import org.osgi.util.converter.DynamicMapFacade;

class MapDelegate<K, V>
implements Map<K, V> {
    private volatile boolean cloned = false;
    private final ConvertingImpl convertingImpl;
    Map<K, V> delegate;

    private MapDelegate(ConvertingImpl converting, Map<K, V> del) {
        this.convertingImpl = converting;
        this.delegate = del;
    }

    static MapDelegate<String, Object> forBean(Object b, Class<?> beanClass, ConvertingImpl converting) {
        return new MapDelegate<String, Object>(converting, new DynamicBeanFacade(b, beanClass, converting));
    }

    static <K, V> Map<K, V> forMap(Map<K, V> m, ConvertingImpl converting) {
        return new MapDelegate<K, V>(converting, new DynamicMapFacade<K, V>(m, converting));
    }

    static <K, V> MapDelegate<K, V> forDictionary(Dictionary<K, V> d, ConvertingImpl converting) {
        return new MapDelegate<K, V>(converting, new DynamicDictionaryFacade<K, V>(d, converting));
    }

    static MapDelegate<String, Object> forDTO(Object obj, Class<?> dtoClass, ConvertingImpl converting) {
        return new MapDelegate<String, Object>(converting, new DynamicDTOFacade(obj, dtoClass, converting));
    }

    static MapDelegate<String, Object> forInterface(Object obj, Class<?> intf, ConvertingImpl converting) {
        return new MapDelegate<String, Object>(converting, new DynamicInterfaceFacade(obj, intf, converting));
    }

    @Override
    public int size() {
        HashSet<Object> keys = new HashSet<Object>();
        Set<K> ks = this.delegate.keySet();
        for (K key : ks) {
            keys.add(this.getConvertedKey(key));
        }
        return keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        Object val = null;
        if (this.internalKeySet().contains(key)) {
            val = this.delegate.get(key);
        }
        if (val == null) {
            key = this.findConvertedKey(this.internalKeySet(), key);
            val = this.delegate.get(key);
        }
        if (val == null) {
            return null;
        }
        return (V)this.getConvertedValue(val);
    }

    private Object getConvertedKey(Object key) {
        return this.convertingImpl.convertMapKey(key);
    }

    private Object getConvertedValue(Object val) {
        return this.convertingImpl.convertMapValue(val);
    }

    private Object findConvertedKey(Set<?> keySet, Object key) {
        for (Object k : keySet) {
            if (!key.equals(k)) continue;
            return k;
        }
        for (Object k : keySet) {
            Object c = this.convertingImpl.converter.convert(k).to(key.getClass());
            if (c == null || !c.equals(key)) continue;
            return k;
        }
        return key;
    }

    @Override
    public V put(K key, V value) {
        this.cloneDelegate();
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.cloneDelegate();
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cloneDelegate();
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.cloned = true;
        this.delegate = new HashMap();
    }

    private Set<K> internalKeySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<K> keySet() {
        HashSet<Object> keys = new HashSet<Object>();
        for (K key : this.internalKeySet()) {
            keys.add(this.getConvertedKey(key));
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
            Object key = this.findConvertedKey(this.internalKeySet(), entry.getKey());
            Object val = this.getConvertedValue(entry.getValue());
            result.add(new MapEntry<Object, Object>(key, val));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void cloneDelegate() {
        if (this.cloned) {
            return;
        }
        this.cloned = true;
        this.delegate = new HashMap<K, V>(this.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        MapEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

