/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.header.OSGiHeader;
import aQute.lib.osgi.Instruction;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public final class DependencyEmbedder {
    public static final String EMBED_DEPENDENCY = "Embed-Dependency";
    public static final String EMBED_DIRECTORY = "Embed-Directory";
    public static final String EMBED_STRIP_GROUP = "Embed-StripGroup";
    public static final String EMBED_STRIP_VERSION = "Embed-StripVersion";
    public static final String EMBED_TRANSITIVE = "Embed-Transitive";
    private static final String MAVEN_DEPENDENCIES = "{maven-dependencies}";
    private static final String MAVEN_DEPENDENCIES_REGEX = "\\{maven-dependencies\\}";
    private String m_embedDirectory;
    private String m_embedStripGroup;
    private String m_embedStripVersion;
    private final Collection m_dependencyArtifacts;
    private final Collection m_inlinedArtifacts;
    private final Collection m_embeddedArtifacts;

    public DependencyEmbedder(Collection dependencyArtifacts) {
        this.m_dependencyArtifacts = dependencyArtifacts;
        this.m_inlinedArtifacts = new HashSet();
        this.m_embeddedArtifacts = new HashSet();
    }

    public void processHeaders(Properties properties) throws MojoExecutionException {
        StringBuffer includeResource = new StringBuffer();
        StringBuffer bundleClassPath = new StringBuffer();
        this.m_inlinedArtifacts.clear();
        this.m_embeddedArtifacts.clear();
        String embedDependencyHeader = properties.getProperty(EMBED_DEPENDENCY);
        if (null != embedDependencyHeader && embedDependencyHeader.length() > 0) {
            this.m_embedDirectory = properties.getProperty(EMBED_DIRECTORY);
            this.m_embedStripGroup = properties.getProperty(EMBED_STRIP_GROUP, "true");
            this.m_embedStripVersion = properties.getProperty(EMBED_STRIP_VERSION);
            Map embedInstructions = OSGiHeader.parseHeader((String)embedDependencyHeader);
            this.processEmbedInstructions(embedInstructions);
            Iterator i = this.m_inlinedArtifacts.iterator();
            while (i.hasNext()) {
                this.inlineDependency((Artifact)i.next(), includeResource);
            }
            i = this.m_embeddedArtifacts.iterator();
            while (i.hasNext()) {
                this.embedDependency((Artifact)i.next(), includeResource, bundleClassPath);
            }
        }
        if (bundleClassPath.length() > 0 && !properties.containsKey("Bundle-ClassPath")) {
            properties.setProperty("Bundle-ClassPath", ".");
        }
        DependencyEmbedder.appendDependencies(properties, "Include-Resource", includeResource.toString());
        DependencyEmbedder.appendDependencies(properties, "Bundle-ClassPath", bundleClassPath.toString());
    }

    private void processEmbedInstructions(Map embedInstructions) throws MojoExecutionException {
        Iterator clauseIterator = embedInstructions.entrySet().iterator();
        while (clauseIterator.hasNext()) {
            boolean inline = false;
            HashSet filteredDependencies = new HashSet(this.m_dependencyArtifacts);
            Map.Entry clause = clauseIterator.next();
            DependencyFilter filter = new DependencyFilter((String)clause.getKey()){

                boolean matches(Artifact dependency) {
                    return super.matches(dependency.getArtifactId());
                }
            };
            filter.filter(filteredDependencies);
            Iterator attrIterator = ((Map)clause.getValue()).entrySet().iterator();
            while (attrIterator.hasNext()) {
                Map.Entry attr = attrIterator.next();
                if ("groupId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getGroupId());
                        }
                    };
                } else if ("artifactId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getArtifactId());
                        }
                    };
                } else if ("version".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            try {
                                return super.matches(dependency.getSelectedVersion().toString());
                            }
                            catch (Exception e) {
                                return super.matches(dependency.getVersion());
                            }
                        }
                    };
                } else if ("scope".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "compile"){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getScope());
                        }
                    };
                } else if ("type".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "jar"){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getType());
                        }
                    };
                } else if ("classifier".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getClassifier());
                        }
                    };
                } else if ("optional".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "false"){

                        boolean matches(Artifact dependency) {
                            return super.matches("" + dependency.isOptional());
                        }
                    };
                } else {
                    if ("inline".equals(attr.getKey())) {
                        inline = Boolean.valueOf((String)attr.getValue());
                        continue;
                    }
                    throw new MojoExecutionException("Unexpected attribute " + attr.getKey());
                }
                filter.filter(filteredDependencies);
            }
            if (inline) {
                this.m_inlinedArtifacts.addAll(filteredDependencies);
                continue;
            }
            this.m_embeddedArtifacts.addAll(filteredDependencies);
        }
        this.m_embeddedArtifacts.removeAll(this.m_inlinedArtifacts);
    }

    private void embedDependency(Artifact dependency, StringBuffer includeResource, StringBuffer bundleClassPath) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            String extension;
            String embedDirectory = this.m_embedDirectory;
            if ("".equals(embedDirectory) || ".".equals(embedDirectory)) {
                embedDirectory = null;
            }
            if (!Boolean.valueOf(this.m_embedStripGroup).booleanValue()) {
                embedDirectory = new File(embedDirectory, dependency.getGroupId()).getPath();
            }
            File targetFile = Boolean.valueOf(this.m_embedStripVersion).booleanValue() ? ((extension = dependency.getArtifactHandler().getExtension()) != null ? new File(embedDirectory, dependency.getArtifactId() + "." + extension) : new File(embedDirectory, dependency.getArtifactId())) : new File(embedDirectory, sourceFile.getName());
            String targetFilePath = targetFile.getPath();
            if (File.separatorChar != '/') {
                targetFilePath = targetFilePath.replace(File.separatorChar, '/');
            }
            if (includeResource.length() > 0) {
                includeResource.append(',');
            }
            includeResource.append(targetFilePath);
            includeResource.append('=');
            includeResource.append(sourceFile);
            if (bundleClassPath.length() > 0) {
                bundleClassPath.append(',');
            }
            bundleClassPath.append(targetFilePath);
        }
    }

    private void inlineDependency(Artifact dependency, StringBuffer includeResource) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            if (includeResource.length() > 0) {
                includeResource.append(',');
            }
            includeResource.append('@');
            includeResource.append(sourceFile);
        }
    }

    public Collection getInlinedArtifacts() {
        return this.m_inlinedArtifacts;
    }

    public Collection getEmbeddedArtifacts() {
        return this.m_embeddedArtifacts;
    }

    private static void appendDependencies(Properties properties, String directiveName, String mavenDependencies) {
        String instruction = properties.getProperty(directiveName);
        if (instruction != null && instruction.length() > 0) {
            if (instruction.indexOf(MAVEN_DEPENDENCIES) >= 0) {
                if (mavenDependencies.length() == 0) {
                    String cleanInstruction = BundlePlugin.removeTagFromInstruction(instruction, MAVEN_DEPENDENCIES);
                    properties.setProperty(directiveName, cleanInstruction);
                } else {
                    String mergedInstruction = instruction.replaceAll(MAVEN_DEPENDENCIES_REGEX, mavenDependencies);
                    properties.setProperty(directiveName, mergedInstruction);
                }
            } else if (mavenDependencies.length() > 0) {
                properties.setProperty(directiveName, instruction + ',' + mavenDependencies);
            }
        } else if (mavenDependencies.length() > 0) {
            properties.setProperty(directiveName, mavenDependencies);
        }
    }

    protected static abstract class DependencyFilter {
        private final Instruction m_instruction;
        private final String m_defaultValue;

        public DependencyFilter(String expression) {
            this(expression, "");
        }

        public DependencyFilter(String expression, String defaultValue) {
            this.m_instruction = Instruction.getPattern((String)expression);
            this.m_defaultValue = defaultValue;
        }

        public void filter(Collection dependencies) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                if (this.matches((Artifact)i.next())) continue;
                i.remove();
            }
        }

        abstract boolean matches(Artifact var1);

        boolean matches(String text) {
            boolean result = null == text ? this.m_instruction.matches(this.m_defaultValue) : this.m_instruction.matches(text);
            return this.m_instruction.isNegated() ? !result : result;
        }
    }
}

