/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.io.IOException;
import java.io.StringReader;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapName;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.name.ReusableAntlrNameParser;
import org.apache.directory.shared.ldap.name.ReusableAntlrTypeLexer;
import org.apache.directory.shared.ldap.name.ReusableAntlrValueLexer;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.NestableRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnParser
implements NameParser {
    private static final Logger log = LoggerFactory.getLogger((Class)DnParser.class);
    private TokenStreamSelector m_selector;
    private final boolean m_isNormalizing;
    private ReusableAntlrNameParser m_parser;
    private ReusableAntlrTypeLexer typeLexer;
    private ReusableAntlrValueLexer valueLexer;
    private static final Object parserMutex = new Object();

    public DnParser() throws NamingException {
        this.m_isNormalizing = false;
        try {
            this.init();
        }
        catch (IOException e) {
            String msg = "failed while initializing a name parser:\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            LdapNamingException ne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnParser(NameComponentNormalizer a_normalizer) throws NamingException {
        try {
            this.init();
        }
        catch (IOException e) {
            String msg = "failed while initializing a name parser:\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            LdapNamingException ne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        Object object = parserMutex;
        synchronized (object) {
            this.m_isNormalizing = true;
            this.m_parser.setNormalizer(a_normalizer);
        }
    }

    public boolean isNormizing() {
        return this.m_isNormalizing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        Object object = parserMutex;
        synchronized (object) {
            this.m_selector = new TokenStreamSelector();
            this.typeLexer = new ReusableAntlrTypeLexer(new StringReader(""));
            this.m_selector.addInputStream((TokenStream)this.typeLexer, "typeLexer");
            this.valueLexer = new ReusableAntlrValueLexer(this.typeLexer.getInputState());
            this.m_selector.addInputStream((TokenStream)this.valueLexer, "valueLexer");
            this.typeLexer.setSelector(this.m_selector);
            this.valueLexer.setSelector(this.m_selector);
            this.m_selector.select("typeLexer");
            this.m_parser = new ReusableAntlrNameParser(this.m_selector);
        }
    }

    private void reset(String name) {
        this.typeLexer.prepareNextInput(new StringReader(name + "#\n"));
        this.valueLexer.prepareNextInput(this.typeLexer.getInputState());
        this.m_parser.resetState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name parse(String name, LdapName emptyName) throws NamingException {
        block20: {
            if (log.isDebugEnabled()) {
                log.debug("Parsing DN '" + name + "'");
            }
            if (name == null || name.trim().equals("")) {
                return null == emptyName ? new LdapName() : emptyName;
            }
            try {
                if (null == emptyName) {
                    Object object = parserMutex;
                    synchronized (object) {
                        this.reset(name);
                        emptyName = new LdapName(this.m_parser.name());
                        break block20;
                    }
                }
                Object object = parserMutex;
                synchronized (object) {
                    this.reset(name);
                    emptyName.setList(this.m_parser.name());
                }
            }
            catch (RecognitionException e) {
                String msg = "Parser failure on name:\n\t" + name;
                msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
                try {
                    this.init();
                }
                catch (IOException e1) {
                    log.error("cannot reinitialize the parser", (Throwable)e1);
                }
                throw new LdapInvalidNameException(msg, ResultCodeEnum.INVALIDDNSYNTAX);
            }
            catch (TokenStreamException e2) {
                String msg = "Parser failure on name:\n\t" + name;
                msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e2);
                try {
                    this.init();
                }
                catch (IOException e1) {
                    log.error("cannot reinitialize the parser", (Throwable)e1);
                }
                throw new LdapInvalidNameException(msg, ResultCodeEnum.INVALIDDNSYNTAX);
            }
            catch (NestableRuntimeException e) {
                Throwable throwable = e.getCause();
                try {
                    this.init();
                }
                catch (IOException e1) {
                    log.error("cannot reinitialize the parser", (Throwable)e1);
                }
                if (throwable instanceof NamingException) {
                    NamingException ne = (NamingException)throwable;
                    throw ne;
                }
                throw e;
            }
        }
        return emptyName;
    }

    public Name parse(String name) throws NamingException {
        return this.parse(name, new LdapName());
    }
}

