/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.ModifyResponse;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyRequestImpl
extends AbstractAbandonableRequest
implements ModifyRequest {
    static final long serialVersionUID = -505803669028990304L;
    private static final transient Logger log = LoggerFactory.getLogger((Class)ModifyRequestImpl.class);
    private String name;
    private ArrayList mods = new ArrayList();
    private ModifyResponse response;

    public ModifyRequestImpl(int id) {
        super(id, TYPE);
    }

    public Collection getModificationItems() {
        return Collections.unmodifiableCollection(this.mods);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addModification(ModificationItem mod) {
        this.mods.add(mod);
    }

    public void removeModification(ModificationItem mod) {
        this.mods.remove(mod);
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyRequest req = (ModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModificationItems().size() != this.mods.size()) {
            return false;
        }
        Iterator list = req.getModificationItems().iterator();
        for (int ii = 0; ii < this.mods.size(); ++ii) {
            ModificationItem item = (ModificationItem)list.next();
            if (this.equals((ModificationItem)this.mods.get(ii), item)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ModificationItem item0, ModificationItem item1) {
        if (item0 == item1) {
            return true;
        }
        if (item0.getModificationOp() != item1.getModificationOp()) {
            return false;
        }
        if (!item0.getAttribute().getID().equals(item1.getAttribute().getID())) {
            return false;
        }
        try {
            Attribute attr0 = item0.getAttribute();
            Attribute attr1 = item1.getAttribute();
            HashSet attrHash0 = new HashSet();
            NamingEnumeration<?> iter0 = attr0.getAll();
            while (iter0.hasMoreElements()) {
                attrHash0.add(iter0.next());
            }
            NamingEnumeration<?> iter1 = attr1.getAll();
            while (iter1.hasMoreElements()) {
                Object value = iter1.next();
                if (!attrHash0.contains(value)) {
                    if (value instanceof byte[]) {
                        String sValue = StringTools.utf8ToString((byte[])value);
                        if (!attrHash0.contains(sValue)) {
                            return false;
                        }
                        attrHash0.remove(sValue);
                        continue;
                    }
                    return false;
                }
                attrHash0.remove(value);
            }
            return attrHash0.size() == 0;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.name).append("'\n");
        if (this.mods != null) {
            for (int i = 0; i < this.mods.size(); ++i) {
                ModificationItem modification = (ModificationItem)this.mods.get(i);
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                switch (modification.getModificationOp()) {
                    case 1: {
                        sb.append(" add\n");
                        break;
                    }
                    case 2: {
                        sb.append(" replace\n");
                        break;
                    }
                    case 3: {
                        sb.append(" delete\n");
                    }
                }
                sb.append("                Modification\n");
                Attribute attribute = modification.getAttribute();
                try {
                    sb.append("                    Type : '").append(attribute.getID()).append("'\n");
                    sb.append("                    Vals\n");
                    for (int j = 0; j < attribute.size(); ++j) {
                        sb.append("                        Val[").append(j).append("] : '");
                        Object attributeValue = attribute.get(j);
                        if (attributeValue instanceof byte[]) {
                            sb.append(StringTools.utf8ToString((byte[])attributeValue)).append('/').append(StringTools.dumpBytes((byte[])attributeValue));
                        } else if (attributeValue instanceof String) {
                            sb.append(attributeValue);
                        } else {
                            sb.append(StringTools.dumpBytes(StringTools.getBytesUtf8(attributeValue.toString())));
                        }
                        sb.append("' \n");
                    }
                    continue;
                }
                catch (NamingException ne) {
                    log.error("Naming exception while printing the '" + attribute.getID() + "'");
                }
            }
        }
        return sb.toString();
    }
}

