/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedure;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredProcedureGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(StoredProcedureGrammar.class);
    private static IGrammar instance = new StoredProcedureGrammar();

    private StoredProcedureGrammar() {
        this.name = StoredProcedureGrammar.class.getName();
        this.statesEnum = StoredProcedureStatesEnum.getInstance();
        this.transitions = new GrammarTransition[8][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, null);
        this.transitions[1][4] = new GrammarTransition(1, 2, 4, (IAction)new GrammarAction("Stores the language"){

            public void action(IAsn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = null;
                if (tlv.getLength() == 0) {
                    log.error(I18n.err((String)"ERR_04038", (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((String)"ERR_04038", (Object[])new Object[0]));
                }
                String language = StringTools.utf8ToString(tlv.getValue().getData());
                if (log.isDebugEnabled()) {
                    log.debug("SP language found: " + language);
                }
                storedProcedure = new StoredProcedure();
                storedProcedure.setLanguage(language);
                storedProcedureContainer.setStoredProcedure(storedProcedure);
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, (IAction)new GrammarAction("Stores the procedure"){

            public void action(IAsn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err((String)"ERR_04039", (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((String)"ERR_04039", (Object[])new Object[0]));
                }
                byte[] procedure = tlv.getValue().getData();
                storedProcedure.setProcedure(procedure);
                if (log.isDebugEnabled()) {
                    log.debug("Procedure found : " + StringTools.utf8ToString(storedProcedure.getProcedure()));
                }
            }
        });
        this.transitions[3][48] = new GrammarTransition(3, 4, 48, (IAction)new GrammarAction("Stores the parameters"){

            public void action(IAsn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                storedProcedureContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[4][48] = new GrammarTransition(4, 5, 48, null);
        this.transitions[5][4] = new GrammarTransition(5, 6, 4, (IAction)new GrammarAction("Store parameter type"){

            public void action(IAsn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err((String)"ERR_04040", (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((String)"ERR_04040", (Object[])new Object[0]));
                }
                StoredProcedure.StoredProcedureParameter parameter = new StoredProcedure.StoredProcedureParameter();
                byte[] parameterType = tlv.getValue().getData();
                parameter.setType(parameterType);
                storedProcedure.setCurrentParameter(parameter);
                if (log.isDebugEnabled()) {
                    log.debug("Parameter type found : " + StringTools.dumpBytes(parameterType));
                }
            }
        });
        this.transitions[6][4] = new GrammarTransition(6, 7, 4, (IAction)new GrammarAction("Store parameter value"){

            public void action(IAsn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    log.error(I18n.err((String)"ERR_04041", (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((String)"ERR_04041", (Object[])new Object[0]));
                }
                byte[] parameterValue = tlv.getValue().getData();
                if (parameterValue.length != 0) {
                    StoredProcedure.StoredProcedureParameter parameter = storedProcedure.getCurrentParameter();
                    parameter.setValue(parameterValue);
                    storedProcedure.addParameter(parameter);
                    if (log.isDebugEnabled()) {
                        log.debug("Parameter value found : " + StringTools.dumpBytes(parameterValue));
                    }
                } else {
                    log.error(I18n.err((String)"ERR_04042", (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((String)"ERR_04042", (Object[])new Object[0]));
                }
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[7][48] = new GrammarTransition(7, 5, 48, null);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

