/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSFileData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERSDirectoryDataGroup
extends ERSDataGroup {
    public ERSDirectoryDataGroup(File file) throws FileNotFoundException {
        super(ERSDirectoryDataGroup.buildGroup(file));
    }

    private static List<ERSData> buildGroup(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            ArrayList<ERSData> arrayList = new ArrayList<ERSData>(fileArray.length);
            for (int j = 0; j != fileArray.length; ++j) {
                if (fileArray[j].isDirectory()) {
                    if (fileArray[j].listFiles().length == 0) continue;
                    arrayList.add(new ERSDirectoryDataGroup(fileArray[j]));
                    continue;
                }
                arrayList.add(new ERSFileData(fileArray[j]));
            }
            return arrayList;
        }
        throw new IllegalArgumentException("file reference does not refer to directory");
    }

    public List<ERSFileData> getFiles() {
        ArrayList<ERSFileData> arrayList = new ArrayList<ERSFileData>();
        for (int j = 0; j != this.dataObjects.size(); ++j) {
            if (!(this.dataObjects.get(j) instanceof ERSFileData)) continue;
            arrayList.add((ERSFileData)this.dataObjects.get(j));
        }
        return arrayList;
    }

    public List<ERSDirectoryDataGroup> getSubdirectories() {
        ArrayList<ERSDirectoryDataGroup> arrayList = new ArrayList<ERSDirectoryDataGroup>();
        for (int j = 0; j != this.dataObjects.size(); ++j) {
            if (!(this.dataObjects.get(j) instanceof ERSDirectoryDataGroup)) continue;
            arrayList.add((ERSDirectoryDataGroup)this.dataObjects.get(j));
        }
        return arrayList;
    }
}

