/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.SamType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

public class PrincipalStoreEntry {
    private String distinguishedName;
    private KerberosPrincipal principal;
    private int keyVersionNumber;
    private SamType samType;
    private boolean disabled;
    private boolean lockedOut;
    private KerberosTime expiration;
    private Map<EncryptionType, EncryptionKey> keyMap;

    PrincipalStoreEntry(String distinguishedName, KerberosPrincipal principal, int keyVersionNumber, Map<EncryptionType, EncryptionKey> keyMap, SamType samType, boolean disabled, boolean lockedOut, KerberosTime expiration) {
        this.distinguishedName = distinguishedName;
        this.principal = principal;
        this.keyVersionNumber = keyVersionNumber;
        this.disabled = disabled;
        this.lockedOut = lockedOut;
        this.expiration = expiration;
        this.samType = samType;
        this.keyMap = keyMap;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isLockedOut() {
        return this.lockedOut;
    }

    public KerberosTime getExpiration() {
        return this.expiration;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public Map<EncryptionType, EncryptionKey> getKeyMap() {
        return this.keyMap;
    }

    public int getKeyVersionNumber() {
        return this.keyVersionNumber;
    }

    public KerberosPrincipal getPrincipal() {
        return this.principal;
    }

    public SamType getSamType() {
        return this.samType;
    }
}

