/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.InMemoryBTreeConfiguration;
import org.apache.directory.mavibot.btree.InMemoryLeaf;
import org.apache.directory.mavibot.btree.InMemoryNode;
import org.apache.directory.mavibot.btree.InMemoryValueHolder;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public class InMemoryBTreeBuilder<K, V> {
    private InMemoryBTreeConfiguration<K, V> btreeConfiguration;

    public InMemoryBTreeBuilder(String name, int numKeysInNode, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        this.btreeConfiguration = new InMemoryBTreeConfiguration();
        this.btreeConfiguration.setName(name);
        this.btreeConfiguration.setPageSize(numKeysInNode);
        this.btreeConfiguration.setKeySerializer(keySerializer);
        this.btreeConfiguration.setValueSerializer(valueSerializer);
    }

    public InMemoryBTreeBuilder(InMemoryBTreeConfiguration<K, V> btreeConfiguration) {
        this.btreeConfiguration = btreeConfiguration;
    }

    public BTree<K, V> build(Iterator<Tuple<K, V>> sortedTupleItr) throws IOException {
        BTree<K, V> btree = BTreeFactory.createInMemoryBTree(this.btreeConfiguration);
        int pageSize = btree.getPageSize();
        int maxElements = (pageSize + 1) * pageSize;
        ArrayList[] pageStack = new ArrayList[15];
        for (int i2 = 0; i2 < 15; ++i2) {
            pageStack[i2] = new ArrayList(maxElements);
        }
        int nbAdded = 0;
        int btreeHeight = 0;
        ArrayList<Tuple<K, V>> tuples = new ArrayList<Tuple<K, V>>(maxElements);
        ArrayList<InMemoryNode<K, V>> nodes = new ArrayList<InMemoryNode<K, V>>();
        while (sortedTupleItr.hasNext()) {
            ++nbAdded;
            Tuple<K, V> tuple = sortedTupleItr.next();
            tuples.add(tuple);
            if (tuples.size() != maxElements) continue;
            InMemoryNode<K, V> node = (InMemoryNode<K, V>)this.addLeaves(btree, tuples, maxElements);
            int level = 0;
            if (node != null) {
                while (true) {
                    pageStack[level].add(node);
                    if (pageStack[level].size() <= btree.getPageSize()) break;
                    node = this.createParentNode(btree, pageStack[level], btree.getPageSize());
                    pageStack[level].clear();
                    ++level;
                }
                ((AbstractBTree)btree).setRootPage((Page)pageStack[level].get(0));
                if (btreeHeight < level) {
                    btreeHeight = level;
                }
            }
            tuples.clear();
        }
        if (tuples.size() > 0) {
            Page<K, V> page = this.addLeaves(btree, tuples, maxElements);
            if (page instanceof InMemoryNode) {
                nodes.add((InMemoryNode)page);
                if (nodes.size() == maxElements) {
                    InMemoryNode<K, V> rootPage = this.createParentNode(btree, nodes, maxElements);
                    ((AbstractBTree)btree).setRootPage(rootPage);
                }
            } else {
                InMemoryLeaf leaf = (InMemoryLeaf)page;
                if (pageStack[0].size() == 0 || leaf.getNbElems() < btree.getPageSize() / 2) {
                    // empty if block
                }
            }
        }
        ((AbstractBTree)btree).getBtreeHeader().setNbElems(nbAdded);
        return btree;
    }

    private InMemoryNode<K, V> createParentNode(BTree<K, V> btree, List<InMemoryNode<K, V>> nodes, int maxElements) {
        InMemoryNode parentNode = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
        int nodePos = 0;
        for (InMemoryNode<K, V> node : nodes) {
            if (nodePos != 0) {
                K key = node.getLeftMostKey();
                BTreeFactory.setKey(btree, parentNode, nodePos - 1, key);
            }
            PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, node);
            parentNode.setPageHolder(nodePos, pageHolder);
            ++nodePos;
        }
        return parentNode;
    }

    private Page<K, V> addLeaves(BTree<K, V> btree, List<Tuple<K, V>> tuples, int maxElements) {
        if (tuples.size() == 0) {
            return null;
        }
        int leafPos = 0;
        if (tuples.size() < btree.getPageSize()) {
            InMemoryLeaf leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.btreeConfiguration.getPageSize());
            for (Tuple<K, V> tuple : tuples) {
                this.injectTuple(btree, leaf, leafPos, tuple);
                ++leafPos;
            }
            return leaf;
        }
        if (tuples.size() < maxElements) {
            InMemoryNode node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
            InMemoryLeaf leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.btreeConfiguration.getPageSize());
            int nodePos = 0;
            for (Tuple<K, V> tuple : tuples) {
                if (leafPos == btree.getPageSize()) {
                    BTreeFactory.setKey(btree, node, nodePos, tuple.getKey());
                    PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, leaf);
                    node.setPageHolder(nodePos, pageHolder);
                    ++nodePos;
                    leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, btree.getPageSize());
                    this.injectTuple(btree, leaf, 0, tuple);
                    leafPos = 1;
                    continue;
                }
                this.injectTuple(btree, leaf, leafPos, tuple);
                ++leafPos;
            }
            if (leafPos > 0) {
                PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, leaf);
                node.setPageHolder(nodePos, pageHolder);
            }
            return node;
        }
        InMemoryNode node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
        InMemoryLeaf leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.btreeConfiguration.getPageSize());
        int nodePos = 0;
        for (Tuple<K, V> tuple : tuples) {
            if (leafPos == btree.getPageSize()) {
                BTreeFactory.setKey(btree, node, nodePos, tuple.getKey());
                PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, leaf);
                node.setPageHolder(nodePos, pageHolder);
                ++nodePos;
                leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, btree.getPageSize());
                this.injectTuple(btree, leaf, 0, tuple);
                leafPos = 1;
                continue;
            }
            this.injectTuple(btree, leaf, leafPos, tuple);
            ++leafPos;
        }
        if (leafPos > 0) {
            PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, leaf);
            node.setPageHolder(nodePos, pageHolder);
        }
        return node;
    }

    private void injectTuple(BTree<K, V> btree, InMemoryLeaf<K, V> leaf, int leafPos, Tuple<K, V> tuple) {
        BTreeFactory.setKey(btree, leaf, leafPos, tuple.getKey());
        InMemoryValueHolder<Object> valueHolder = new InMemoryValueHolder<Object>(btree, tuple.getValue());
        BTreeFactory.setValue(btree, leaf, leafPos, valueHolder);
    }

    private int add(BTree<K, V> btree, Page<K, V>[] pageStack, int level, Page<K, V> page, Tuple<K, V> tuple) {
        if (page == null) {
            if (level == 0) {
                InMemoryLeaf leaf;
                pageStack[level] = leaf = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.btreeConfiguration.getPageSize());
                BTreeFactory.setKey(btree, leaf, 0, tuple.getKey());
                InMemoryValueHolder<Object> valueHolder = new InMemoryValueHolder<Object>(btree, tuple.getValue());
                BTreeFactory.setValue(btree, leaf, 0, valueHolder);
            } else {
                InMemoryNode node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
                BTreeFactory.setKey(btree, node, 0, tuple.getKey());
                PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, pageStack[level - 1]);
                node.setPageHolder(0, pageHolder);
            }
        } else if (page.getNbElems() != btree.getPageSize()) {
            if (page.isLeaf()) {
                BTreeFactory.setKey(btree, page, page.getNbElems(), tuple.getKey());
                InMemoryValueHolder<Object> valueHolder = new InMemoryValueHolder<Object>(btree, tuple.getValue());
                BTreeFactory.setValue(btree, page, page.getNbElems(), valueHolder);
            } else {
                BTreeFactory.setKey(btree, page, page.getNbElems(), tuple.getKey());
                PageHolder<K, V> pageHolder = new PageHolder<K, V>(btree, pageStack[level - 1]);
                ((InMemoryNode)page).setPageHolder(page.getNbElems(), pageHolder);
            }
        }
        return level;
    }

    private Page<K, V> attachNodes(List<Page<K, V>> children, BTree<K, V> btree) throws IOException {
        if (children.size() == 1) {
            return children.get(0);
        }
        ArrayList<Page<K, V>> lstNodes = new ArrayList<Page<K, V>>();
        int numChildren = this.btreeConfiguration.getPageSize() + 1;
        InMemoryNode node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
        lstNodes.add(node);
        int i2 = 0;
        int totalNodes = 0;
        for (Page<K, V> p : children) {
            if (i2 != 0) {
                BTreeFactory.setKey(btree, node, i2 - 1, p.getLeftMostKey());
            }
            node.setPageHolder(i2, new PageHolder<K, V>(btree, p));
            ++i2;
            if (++totalNodes % numChildren != 0) continue;
            i2 = 0;
            node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.btreeConfiguration.getPageSize());
            lstNodes.add(node);
        }
        AbstractPage lastNode = (AbstractPage)lstNodes.get(lstNodes.size() - 1);
        for (int j = 0; j < lastNode.getNbElems(); ++j) {
            if (lastNode.getKey(j) != null) continue;
            int n = j;
            lastNode.setNbElems(n);
            KeyHolder<K>[] keys = lastNode.getKeys();
            lastNode.setKeys((KeyHolder[])Array.newInstance(KeyHolder.class, n));
            System.arraycopy(keys, 0, lastNode.getKeys(), 0, n);
            break;
        }
        return this.attachNodes(lstNodes, btree);
    }
}

