/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class DseTypeSyntaxChecker
extends SyntaxChecker {
    private static final String[] DSE_BITS_STRINGS = new String[]{"root", "glue", "cp", "entry", "alias", "subr", "nssr", "supr", "xr", "admPoint", "subentry", "shadow", "zombie", "immSupr", "rhob", "sa"};
    private static final Set<String> DSE_BITS = new HashSet<String>();
    public static final DseTypeSyntaxChecker INSTANCE;

    private DseTypeSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (strValue.charAt(0) != '(' || strValue.charAt(strValue.length() - 1) != ')') {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        HashSet<String> keywords = new HashSet<String>();
        int len = strValue.length() - 1;
        boolean needKeyword = true;
        int i2 = 1;
        while (i2 < len) {
            while (i2 < len && strValue.charAt(i2) == ' ') {
                ++i2;
            }
            int pos = i2;
            while (i2 < len && Chars.isAlphaASCII(strValue, pos)) {
                ++pos;
            }
            if (pos == i2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            String keyword = strValue.substring(i2, pos);
            if (!DSE_BITS.contains(keyword)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (keywords.contains(keyword)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            keywords.add(keyword);
            needKeyword = false;
            for (i2 = pos; i2 < len && strValue.charAt(i2) == ' '; ++i2) {
            }
            if (i2 >= len || strValue.charAt(i2) != '$') continue;
            ++i2;
            needKeyword = true;
        }
        if (LOG.isDebugEnabled()) {
            if (needKeyword) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            } else {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            }
        }
        return !needKeyword;
    }

    static {
        for (String country : DSE_BITS_STRINGS) {
            DSE_BITS.add(country);
        }
        INSTANCE = new DseTypeSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.20");
        for (String country : DSE_BITS_STRINGS) {
            DSE_BITS.add(country);
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DseTypeSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.20");
        }

        @Override
        public DseTypeSyntaxChecker build() {
            return new DseTypeSyntaxChecker(this.oid);
        }
    }
}

