/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 583;
    FreePhysicalRowId[] slots = new FreePhysicalRowId[583];

    FreePhysicalRowIdPage(BlockIo block) {
        super(block);
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)view;
        }
        return new FreePhysicalRowIdPage(block);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short i2) {
        this.block.writeShort(18, i2);
    }

    void free(int slot) {
        this.get(slot).setSize(0);
        this.setCount((short)(this.getCount() - 1));
    }

    FreePhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        return this.get(slot);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getSize() != 0;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    FreePhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new FreePhysicalRowId(this.block, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 14);
    }

    int getFirstFree() {
        for (int i2 = 0; i2 < 583; ++i2) {
            if (!this.isFree(i2)) continue;
            return i2;
        }
        return -1;
    }

    int getFirstLargerThan(int size) {
        for (int i2 = 0; i2 < 583; ++i2) {
            if (!this.isAllocated(i2) || this.get(i2).getSize() < size) continue;
            return i2;
        }
        return -1;
    }
}

