/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectClassHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectClassHelper.class);

    private ObjectClassHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(ObjectClass objectClass, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                objectClass.unlock();
                ObjectClassHelper.buildSuperiors(objectClass, errors, registries);
                ObjectClassHelper.buildMay(objectClass, errors, registries);
                ObjectClassHelper.buildMust(objectClass, errors, registries);
                for (AttributeType mayAttributeType : objectClass.getMayAttributeTypes()) {
                    registries.addReference(objectClass, mayAttributeType);
                }
                for (AttributeType mustAttributeType : objectClass.getMustAttributeTypes()) {
                    registries.addReference(objectClass, mustAttributeType);
                }
                for (ObjectClass superiorObjectClass : objectClass.getSuperiors()) {
                    registries.addReference(objectClass, superiorObjectClass);
                }
            }
            finally {
                objectClass.lock();
            }
        }
    }

    private static void buildSuperiors(ObjectClass objectClass, List<Throwable> errors, Registries registries) {
        ObjectClassRegistry ocRegistry = registries.getObjectClassRegistry();
        List<String> superiorOids = objectClass.getSuperiorOids();
        if (superiorOids != null) {
            objectClass.getSuperiors().clear();
            block7: for (String superiorName : superiorOids) {
                LdapSchemaException ldapSchemaException;
                String msg;
                try {
                    ObjectClass superior = (ObjectClass)ocRegistry.lookup(ocRegistry.getOidByName(superiorName));
                    switch (objectClass.getType()) {
                        case ABSTRACT: {
                            if (superior.getType() == ObjectClassTypeEnum.ABSTRACT) break;
                            msg = I18n.err((I18n)I18n.ERR_04318, (Object[])new Object[]{objectClass.getOid(), superior.getObjectType(), superior});
                            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_ABSTRACT_MUST_INHERIT_FROM_ABSTRACT_OC, msg);
                            ldapSchemaException.setSourceObject(objectClass);
                            errors.add(ldapSchemaException);
                            LOG.info(msg);
                            continue block7;
                        }
                        case AUXILIARY: {
                            if (superior.getType() != ObjectClassTypeEnum.STRUCTURAL) break;
                            msg = I18n.err((I18n)I18n.ERR_04319, (Object[])new Object[]{objectClass.getOid(), superior});
                            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_AUXILIARY_CANNOT_INHERIT_FROM_STRUCTURAL_OC, msg);
                            ldapSchemaException.setSourceObject(objectClass);
                            errors.add(ldapSchemaException);
                            LOG.info(msg);
                            continue block7;
                        }
                        case STRUCTURAL: {
                            if (superior.getType() != ObjectClassTypeEnum.AUXILIARY) break;
                            msg = I18n.err((I18n)I18n.ERR_04320, (Object[])new Object[]{objectClass.getOid(), superior});
                            ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_STRUCTURAL_CANNOT_INHERIT_FROM_AUXILIARY_OC, msg);
                            ldapSchemaException.setSourceObject(objectClass);
                            errors.add(ldapSchemaException);
                            LOG.info(msg);
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected ObjectClassTypeEnum: " + (Object)((Object)objectClass.getType()));
                        }
                    }
                    objectClass.getSuperiors().add(superior);
                }
                catch (LdapException ne) {
                    msg = I18n.err((I18n)I18n.ERR_04321, (Object[])new Object[]{objectClass.getOid(), superiorName});
                    ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_NONEXISTENT_SUPERIOR, msg, ne);
                    ldapSchemaException.setSourceObject(objectClass);
                    ldapSchemaException.setRelatedId(superiorName);
                    errors.add(ldapSchemaException);
                    LOG.info(msg);
                    return;
                }
            }
        }
    }

    private static void buildMust(ObjectClass objectClass, List<Throwable> errors, Registries registries) {
        AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
        List<String> mustAttributeTypeOids = objectClass.getMustAttributeTypeOids();
        if (mustAttributeTypeOids != null) {
            objectClass.getMustAttributeTypes().clear();
            for (String mustAttributeTypeName : mustAttributeTypeOids) {
                LdapSchemaException ldapSchemaException;
                String msg;
                try {
                    AttributeType attributeType = (AttributeType)atRegistry.lookup(mustAttributeTypeName);
                    if (attributeType.isCollective()) {
                        msg = I18n.err((I18n)I18n.ERR_04484_COLLECTIVE_NOT_ALLOWED_IN_MUST, (Object[])new Object[]{mustAttributeTypeName, objectClass.getOid()});
                        ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_COLLECTIVE_NOT_ALLOWED_IN_MUST, msg);
                        ldapSchemaException.setSourceObject(objectClass);
                        ldapSchemaException.setRelatedId(mustAttributeTypeName);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        continue;
                    }
                    if (objectClass.getMustAttributeTypes().contains(attributeType)) {
                        msg = I18n.err((I18n)I18n.ERR_04324, (Object[])new Object[]{objectClass.getOid(), mustAttributeTypeName});
                        ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_DUPLICATE_AT_IN_MUST, msg);
                        ldapSchemaException.setSourceObject(objectClass);
                        ldapSchemaException.setRelatedId(mustAttributeTypeName);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        continue;
                    }
                    if (objectClass.getMayAttributeTypes().contains(attributeType)) {
                        msg = I18n.err((I18n)I18n.ERR_04325, (Object[])new Object[]{objectClass.getOid(), mustAttributeTypeName});
                        ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_DUPLICATE_AT_IN_MAY_AND_MUST, msg);
                        ldapSchemaException.setSourceObject(objectClass);
                        ldapSchemaException.setRelatedId(mustAttributeTypeName);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        continue;
                    }
                    objectClass.getMustAttributeTypes().add(attributeType);
                }
                catch (LdapException ne) {
                    msg = I18n.err((I18n)I18n.ERR_04326, (Object[])new Object[]{objectClass.getOid(), mustAttributeTypeName});
                    ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_NONEXISTENT_MUST_AT, msg, ne);
                    ldapSchemaException.setSourceObject(objectClass);
                    ldapSchemaException.setRelatedId(mustAttributeTypeName);
                    errors.add(ldapSchemaException);
                    LOG.info(msg);
                }
            }
        }
    }

    private static void buildMay(ObjectClass objectClass, List<Throwable> errors, Registries registries) {
        AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
        List<String> mayAttributeTypeOids = objectClass.getMayAttributeTypeOids();
        if (mayAttributeTypeOids != null) {
            objectClass.getMayAttributeTypes().clear();
            for (String mayAttributeTypeName : mayAttributeTypeOids) {
                LdapSchemaException ldapSchemaException;
                String msg;
                try {
                    AttributeType attributeType = (AttributeType)atRegistry.lookup(mayAttributeTypeName);
                    if (attributeType.isCollective()) {
                        msg = I18n.err((I18n)I18n.ERR_04485_COLLECTIVE_NOT_ALLOWED_IN_MAY, (Object[])new Object[]{mayAttributeTypeName, objectClass.getOid()});
                        ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_COLLECTIVE_NOT_ALLOWED_IN_MAY, msg);
                        ldapSchemaException.setSourceObject(objectClass);
                        ldapSchemaException.setRelatedId(mayAttributeTypeName);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        continue;
                    }
                    if (objectClass.getMayAttributeTypes().contains(attributeType)) {
                        msg = I18n.err((I18n)I18n.ERR_04322, (Object[])new Object[]{objectClass.getOid(), mayAttributeTypeName});
                        ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_DUPLICATE_AT_IN_MAY, msg);
                        ldapSchemaException.setSourceObject(objectClass);
                        ldapSchemaException.setRelatedId(mayAttributeTypeName);
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                        continue;
                    }
                    objectClass.getMayAttributeTypes().add(attributeType);
                }
                catch (LdapException ne) {
                    msg = I18n.err((I18n)I18n.ERR_04323, (Object[])new Object[]{objectClass.getOid(), mayAttributeTypeName});
                    ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_NONEXISTENT_MAY_AT, msg, ne);
                    ldapSchemaException.setSourceObject(objectClass);
                    ldapSchemaException.setRelatedId(mayAttributeTypeName);
                    errors.add(ldapSchemaException);
                    LOG.info(msg);
                }
            }
        }
    }

    public static void removeFromRegistries(ObjectClass objectClass, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            ObjectClassRegistry objectClassRegistry = registries.getObjectClassRegistry();
            objectClassRegistry.unregisterDescendants(objectClass, objectClass.getSuperiors());
            if (objectClass.getMayAttributeTypes() != null) {
                for (AttributeType may : objectClass.getMayAttributeTypes()) {
                    registries.delReference(objectClass, may);
                }
            }
            if (objectClass.getMustAttributeTypes() != null) {
                for (AttributeType must : objectClass.getMustAttributeTypes()) {
                    registries.delReference(objectClass, must);
                }
            }
            if (objectClass.getSuperiors() != null) {
                for (ObjectClass superior : objectClass.getSuperiors()) {
                    registries.delReference(objectClass, superior);
                }
            }
        }
    }
}

