/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.util.metadata.builder.InjectableMethod;
import org.apache.deltaspike.core.util.metadata.builder.ParameterValueRedefiner;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.SecuredReturn;
import org.apache.deltaspike.security.api.authorization.SecurityBindingType;
import org.apache.deltaspike.security.api.authorization.SecurityDefinitionException;
import org.apache.deltaspike.security.api.authorization.SecurityViolation;
import org.apache.deltaspike.security.impl.authorization.SecurityParameterValueRedefiner;
import org.apache.deltaspike.security.impl.extension.AuthorizationParameter;
import org.apache.deltaspike.security.impl.util.SecurityUtils;

@Typed
class Authorizer {
    private Annotation bindingAnnotation;
    private Map<Method, Object> bindingSecurityBindingMembers = new HashMap<Method, Object>();
    private Set<AuthorizationParameter> authorizationParameters = new HashSet<AuthorizationParameter>();
    private Class<?> securedReturnType;
    private volatile AnnotatedMethod<?> boundAuthorizerMethod;
    private volatile Bean<?> boundAuthorizerBean;
    private volatile InjectableMethod<?> boundAuthorizerMethodProxy;

    Authorizer(Annotation bindingAnnotation, AnnotatedMethod<?> boundAuthorizerMethod) {
        this.bindingAnnotation = bindingAnnotation;
        this.boundAuthorizerMethod = boundAuthorizerMethod;
        try {
            for (Method method : bindingAnnotation.annotationType().getDeclaredMethods()) {
                if (method.isAnnotationPresent(Nonbinding.class)) continue;
                this.bindingSecurityBindingMembers.put(method, method.invoke((Object)bindingAnnotation, new Object[0]));
            }
        }
        catch (InvocationTargetException ex) {
            throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
        }
        for (AnnotatedParameter annotatedParameter : boundAuthorizerMethod.getParameters()) {
            HashSet<Annotation> securityParameterBindings = null;
            Class<?> securedReturnType = null;
            for (Annotation annotation : annotatedParameter.getAnnotations()) {
                if (SecurityUtils.isMetaAnnotatedWithSecurityParameterBinding(annotation)) {
                    if (securityParameterBindings == null) {
                        securityParameterBindings = new HashSet<Annotation>();
                    }
                    securityParameterBindings.add(annotation);
                }
                if (!annotation.annotationType().equals(SecuredReturn.class)) continue;
                securedReturnType = boundAuthorizerMethod.getJavaMember().getParameterTypes()[annotatedParameter.getPosition()];
            }
            if (securityParameterBindings != null && securedReturnType != null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("@SecurityParameterBinding annotations must not occure ");
                errorMessage.append("at the same parameter with @Result annotation, but parameter ");
                errorMessage.append(annotatedParameter.getPosition()).append(" of method ");
                errorMessage.append(boundAuthorizerMethod.getJavaMember()).append(" is annotated with @Result and ");
                boolean first = true;
                for (Annotation securityParameterBinding : securityParameterBindings) {
                    if (first) {
                        first = false;
                    } else {
                        errorMessage.append(" and ");
                    }
                    errorMessage.append(securityParameterBinding);
                }
                if (securityParameterBindings.size() == 1) {
                    errorMessage.append(", which is a @SecurityParameterBinding annotation");
                } else {
                    errorMessage.append(", which are @SecurityParameterBinding annotations");
                }
                throw new SecurityDefinitionException(errorMessage.toString());
            }
            if (securityParameterBindings != null) {
                AuthorizationParameter authorizationParameter = new AuthorizationParameter(annotatedParameter.getBaseType(), securityParameterBindings);
                this.authorizationParameters.add(authorizationParameter);
                continue;
            }
            if (securedReturnType == null) continue;
            if (this.securedReturnType != null && !this.securedReturnType.equals(securedReturnType)) {
                throw new SecurityDefinitionException("More than one parameter of " + boundAuthorizerMethod.getJavaMember() + " is annotated with @Result");
            }
            this.securedReturnType = securedReturnType;
        }
    }

    boolean isBeforeMethodInvocationAuthorizer() {
        return this.securedReturnType == null;
    }

    boolean isAfterMethodInvocationAuthorizer() {
        return this.securedReturnType != null;
    }

    void authorize(InvocationContext ic, Object returnValue, BeanManager beanManager) throws IllegalAccessException, IllegalArgumentException {
        if (this.boundAuthorizerBean == null) {
            this.lazyInitTargetBean(beanManager);
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(this.boundAuthorizerBean);
        Object reference = beanManager.getReference(this.boundAuthorizerBean, this.boundAuthorizerMethod.getJavaMember().getDeclaringClass(), creationalContext);
        Object result = this.boundAuthorizerMethodProxy.invoke(reference, creationalContext, (ParameterValueRedefiner)new SecurityParameterValueRedefiner(creationalContext, ic, returnValue));
        if (Boolean.FALSE.equals(result)) {
            HashSet<1> violations = new HashSet<1>();
            violations.add(new SecurityViolation(){
                private static final long serialVersionUID = 2358753444038521129L;

                public String getReason() {
                    return "Authorization check failed";
                }
            });
            throw new AccessDeniedException(violations);
        }
    }

    private synchronized void lazyInitTargetBean(BeanManager beanManager) {
        if (this.boundAuthorizerBean == null) {
            Method method = this.boundAuthorizerMethod.getJavaMember();
            Set beans = beanManager.getBeans(method.getDeclaringClass(), new Annotation[0]);
            this.boundAuthorizerBean = beanManager.resolve(beans);
            if (this.boundAuthorizerBean == null) {
                throw new IllegalStateException("Exception looking up authorizer method bean - no beans found for method [" + method.getDeclaringClass() + "." + method.getName() + "]");
            }
            this.boundAuthorizerMethodProxy = new InjectableMethod(this.boundAuthorizerMethod, this.boundAuthorizerBean, beanManager);
        }
    }

    boolean matchesBindings(Annotation annotation, Set<AuthorizationParameter> parameterBindings, Class<?> returnType) {
        if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class) && annotation.annotationType().isAnnotationPresent(Stereotype.class)) {
            annotation = SecurityUtils.resolveSecurityBindingType(annotation);
        }
        if (!annotation.annotationType().equals(this.bindingAnnotation.annotationType())) {
            return false;
        }
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            if (method.isAnnotationPresent(Nonbinding.class)) continue;
            if (!this.bindingSecurityBindingMembers.containsKey(method)) {
                return false;
            }
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (this.bindingSecurityBindingMembers.get(method).equals(value)) continue;
                return false;
            }
            catch (InvocationTargetException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
        }
        for (AuthorizationParameter authorizationParameter : this.authorizationParameters) {
            boolean found = false;
            for (AuthorizationParameter parameterBinding : parameterBindings) {
                if (!parameterBinding.matches(authorizationParameter)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return this.matches(returnType);
    }

    private boolean matches(Class<?> returnType) {
        if (this.securedReturnType == null) {
            return true;
        }
        if (this.securedReturnType.isAssignableFrom(returnType)) {
            return true;
        }
        return this.securedReturnType.equals(Void.class) && returnType.equals(Void.TYPE);
    }

    Method getBoundAuthorizerMethod() {
        return this.boundAuthorizerMethod.getJavaMember();
    }
}

