/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesCompactSketch;

final class DirectArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private final MemorySegment seg_;

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, MemorySegment dstSeg) {
        this(sketch, sketch.getThetaLong(), dstSeg);
    }

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, long thetaLong, MemorySegment dstSeg) {
        super(sketch.getNumValues());
        DirectArrayOfDoublesCompactSketch.checkMemorySegmentSize(dstSeg, sketch.getRetainedEntries(), sketch.getNumValues());
        this.seg_ = dstSeg;
        dstSeg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        dstSeg.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        dstSeg.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        dstSeg.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        this.isEmpty_ = sketch.isEmpty();
        int count = sketch.getRetainedEntries();
        dstSeg.set(ValueLayout.JAVA_BYTE, 4L, (byte)((this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstSeg.set(ValueLayout.JAVA_BYTE, 5L, (byte)this.numValues_);
        dstSeg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, Util.computeSeedHash(sketch.getSeed()));
        this.thetaLong_ = Math.min(sketch.getThetaLong(), thetaLong);
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        if (count > 0) {
            int keyOffset = 24;
            int valuesOffset = keyOffset + 8 * sketch.getRetainedEntries();
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            int actualCount = 0;
            while (it.next()) {
                if (it.getKey() >= this.thetaLong_) continue;
                dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)keyOffset, it.getKey());
                MemorySegment.copy(it.getValues(), 0, dstSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)valuesOffset, this.numValues_);
                keyOffset += 8;
                valuesOffset += 8 * this.numValues_;
                ++actualCount;
            }
            dstSeg.set(ValueLayout.JAVA_INT_UNALIGNED, 16L, actualCount);
        }
    }

    DirectArrayOfDoublesCompactSketch(long[] keys, double[] values, long thetaLong, boolean isEmpty, int numValues, short seedHash, MemorySegment dstSeg) {
        super(numValues);
        DirectArrayOfDoublesCompactSketch.checkMemorySegmentSize(dstSeg, values.length, numValues);
        this.seg_ = dstSeg;
        dstSeg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        dstSeg.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        dstSeg.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        dstSeg.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        this.isEmpty_ = isEmpty;
        int count = keys.length;
        dstSeg.set(ValueLayout.JAVA_BYTE, 4L, (byte)((this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstSeg.set(ValueLayout.JAVA_BYTE, 5L, (byte)this.numValues_);
        dstSeg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, seedHash);
        this.thetaLong_ = thetaLong;
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        if (count > 0) {
            dstSeg.set(ValueLayout.JAVA_INT_UNALIGNED, 16L, count);
            MemorySegment.copy(keys, 0, dstSeg, ValueLayout.JAVA_LONG_UNALIGNED, 24L, count);
            MemorySegment.copy(values, 0, dstSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L + 8L * (long)count, values.length);
        }
    }

    DirectArrayOfDoublesCompactSketch(MemorySegment seg) {
        super(seg.get(ValueLayout.JAVA_BYTE, 5L));
        this.seg_ = seg;
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(this.seg_.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = this.seg_.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        this.isEmpty_ = (this.seg_.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.thetaLong_ = this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    DirectArrayOfDoublesCompactSketch(MemorySegment seg, long seed) {
        super(seg.get(ValueLayout.JAVA_BYTE, 5L));
        this.seg_ = seg;
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(this.seg_.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = this.seg_.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        Util.checkSeedHashes(seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L), Util.computeSeedHash(seed));
        this.isEmpty_ = (this.seg_.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.thetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    @Override
    public ArrayOfDoublesCompactSketch compact(MemorySegment dstSeg) {
        if (dstSeg == null) {
            return new HeapArrayOfDoublesCompactSketch(this.getKeys(), this.getValuesAsOneDimension(), this.thetaLong_, this.isEmpty_, this.numValues_, this.getSeedHash());
        }
        MemorySegment.copy(this.seg_, 0L, dstSeg, 0L, this.seg_.byteSize());
        return new DirectArrayOfDoublesCompactSketch(dstSeg);
    }

    @Override
    public int getRetainedEntries() {
        boolean hasEntries = (this.seg_.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) != 0;
        return hasEntries ? this.seg_.get(ValueLayout.JAVA_INT_UNALIGNED, 16L) : 0;
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int valuesOffset = 24 + 8 * count;
            for (int i = 0; i < count; ++i) {
                double[] array = new double[this.numValues_];
                MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, valuesOffset, array, 0, this.numValues_);
                values[i] = array;
                valuesOffset += 8 * this.numValues_;
            }
        }
        return values;
    }

    @Override
    double[] getValuesAsOneDimension() {
        int count = this.getRetainedEntries();
        int numDoubles = count * this.numValues_;
        double[] values = new double[numDoubles];
        if (count > 0) {
            int valuesOffset = 24 + 8 * count;
            MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, valuesOffset, values, 0, numDoubles);
        }
        return values;
    }

    @Override
    long[] getKeys() {
        int count = this.getRetainedEntries();
        long[] keys = new long[count];
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                MemorySegment.copy(this.seg_, ValueLayout.JAVA_LONG_UNALIGNED, 24L, keys, 0, count);
            }
        }
        return keys;
    }

    @Override
    public byte[] toByteArray() {
        int sizeBytes = this.getCurrentBytes();
        byte[] byteArray = new byte[sizeBytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        MemorySegment.copy(this.seg_, 0L, seg, 0L, sizeBytes);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.seg_, 24, this.getRetainedEntries(), this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.seg_.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L);
    }

    @Override
    public boolean hasMemorySegment() {
        return true;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg_;
    }

    private static void checkMemorySegmentSize(MemorySegment seg, int numEntries, int numValues) {
        int sizeNeeded = 24 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > seg.byteSize()) {
            throw new SketchesArgumentException("Not enough space: need " + sizeNeeded + " bytes, got " + seg.byteSize() + " bytes");
        }
    }
}

