/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.maven_plugin.common;

/**
 * Represents a document file (wsdl, wadl) that is stored in a maven repository
 */
//TODO: Move to the common plugin module
public class DocumentArtifact {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;

    public DocumentArtifact() {
        type = "wadl";
    }

    public String getGroupId() {
        return groupId;
    }
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
    public String getArtifactId() {
        return artifactId;
    }
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }
    public String getVersion() {
        return version;
    }
    public void setVersion(String version) {
        this.version = version;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }

    public boolean doesMatch(DocumentArtifact artifact) {
        return type.equals(artifact.getType()) && groupId.equals(artifact.getGroupId())
              && artifactId.equals(artifact.getArtifactId())
              && (version == null || version.equals(artifact.getVersion()));
    }
}
