/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.parser.Argument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Option;
import org.apache.cxf.tools.common.toolspec.parser.OptionGroup;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Form
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Form.class);
    private final Element element;
    private final List<Object> arguments = new ArrayList<Object>();
    private final List<Object> optionGroups = new ArrayList<Object>();
    private final List<Object> options = new ArrayList<Object>();

    public Form(Element el) {
        this.element = el;
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.element, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"optionGroup");
        for (Element elem : elemList) {
            this.optionGroups.add(new OptionGroup(elem));
        }
        elemList = DOMUtils.findAllElementsByTagNameNS((Element)this.element, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"argument");
        for (Element elem : elemList) {
            this.arguments.add(new Argument(elem));
        }
        this.getOptions(this.element);
    }

    private void getOptions(Element el) {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"option".equals(node.getNodeName())) continue;
            this.options.add(new Option((Element)node));
        }
    }

    public boolean accept(TokenInputStream args, Element result, ErrorVisitor errors) {
        int i;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for form of usage: " + this + ", tokens are " + args);
        }
        int oldpos = args.getPosition();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Position is: " + oldpos);
        }
        boolean hasInfo = this.hasInfoOption(args);
        args.setPosition(oldpos);
        while (args.available() > 0) {
            int i2;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Args is available");
            }
            boolean accepted = false;
            for (i2 = 0; i2 < this.optionGroups.size(); ++i2) {
                OptionGroup optionGroup = (OptionGroup)this.optionGroups.get(i2);
                if (!optionGroup.accept(args, result, errors)) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                for (i2 = 0; i2 < this.options.size(); ++i2) {
                    Option option = (Option)this.options.get(i2);
                    if (!option.accept(args, result, errors)) continue;
                    accepted = true;
                    break;
                }
            }
            if (accepted) continue;
            break;
        }
        for (i = 0; i < this.optionGroups.size(); ++i) {
            OptionGroup optionGroup = (OptionGroup)this.optionGroups.get(i);
            if (optionGroup.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        for (i = 0; i < this.options.size(); ++i) {
            Option option = (Option)this.options.get(i);
            if (option.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.size(); ++i) {
                Argument argument = (Argument)this.arguments.get(i);
                argument.accept(args, result, errors);
                if (argument.isSatisfied(errors) || hasInfo) continue;
                return false;
            }
        }
        if (args.available() > 0) {
            String next = args.peek();
            if (next.startsWith("-")) {
                errors.add(new ErrorVisitor.UnexpectedOption(next));
            } else {
                errors.add(new ErrorVisitor.UnexpectedArgument(next));
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this + " form is returning false as there are more args available" + " that haven't been consumed");
            }
            args.setPosition(oldpos);
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Form " + this + " is returning true");
        }
        return true;
    }

    public boolean hasInfoOption(TokenInputStream args) {
        int pos = args.getPosition();
        args.setPosition(0);
        while (args.available() > 0) {
            String optionValue = args.read();
            if (!"-?".equals(optionValue) && !"-help".equals(optionValue) && !"-h".equals(optionValue) && !"-v".equals(optionValue)) continue;
            return true;
        }
        args.setPosition(pos);
        return false;
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        return true;
    }

    public String getName() {
        if (this.element.hasAttribute("value")) {
            return this.element.getAttribute("value");
        }
        return "default";
    }

    public String toString() {
        return this.getName();
    }
}

