/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(ServerFactoryBean.class);
    private Server server;
    private boolean start = true;
    private Object serviceBean;
    private List<String> schemaLocations;
    private Invoker invoker;

    public ServerFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ServerFactoryBean(ReflectionServiceFactoryBean sbean) {
        super(sbean);
    }

    public String getBeanName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Server create() {
        try {
            this.applyExtraClass();
            if (this.serviceBean != null && this.getServiceClass() == null) {
                this.setServiceClass(ClassHelper.getRealClass((Object)this.serviceBean));
            }
            if (this.invoker != null) {
                this.getServiceFactory().setInvoker(this.invoker);
            } else if (this.serviceBean != null) {
                this.invoker = this.createInvoker();
                this.getServiceFactory().setInvoker(this.invoker);
            }
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
            if (ep.getService().getInvoker() == null) {
                if (this.invoker == null) {
                    ep.getService().setInvoker(this.createInvoker());
                } else {
                    ep.getService().setInvoker(this.invoker);
                }
            }
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        if (this.serviceBean != null) {
            this.initializeAnnotationInterceptors(this.server.getEndpoint(), ClassHelper.getRealClass((Object)this.getServiceBean()));
        } else if (this.getServiceClass() != null) {
            this.initializeAnnotationInterceptors(this.server.getEndpoint(), this.getServiceClass());
        }
        this.applyFeatures();
        return this.server;
    }

    @Override
    protected void initializeServiceFactory() {
        super.initializeServiceFactory();
        DataBinding db = this.getServiceFactory().getDataBinding();
        if (db instanceof AbstractDataBinding && this.schemaLocations != null) {
            ResourceManager rr = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
            ArrayList<DOMSource> schemas = new ArrayList<DOMSource>();
            for (String l : this.schemaLocations) {
                Document d;
                URL url = (URL)rr.resolveResource(l, URL.class);
                if (url == null) {
                    URIResolver res;
                    try {
                        res = new URIResolver(l);
                    }
                    catch (IOException e) {
                        throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, new Object[0]), (Throwable)e);
                    }
                    if (!res.isResolved()) {
                        throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, new Object[0]));
                    }
                    url = res.getURL();
                }
                try {
                    d = DOMUtils.readXml((InputStream)url.openStream());
                }
                catch (Exception e) {
                    throw new ServiceConstructionException(new Message("ERROR_READING_SCHEMA", LOG, new Object[]{l}), (Throwable)e);
                }
                schemas.add(new DOMSource(d, url.toString()));
            }
            ((AbstractDataBinding)db).setSchemas(schemas);
        }
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map props = this.getProperties();
        if (props != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            DataBinding dataBinding = this.getServiceFactory().getDataBinding();
            if (dataBinding instanceof JAXBDataBinding) {
                ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
            }
        }
    }

    protected Invoker createInvoker() {
        if (this.getServiceBean() == null) {
            return new FactoryInvoker((Factory)new SingletonFactory(this.getServiceClass()));
        }
        return new BeanInvoker(this.getServiceBean());
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public Class<?> getServiceBeanClass() {
        if (this.serviceBean != null) {
            return ClassHelper.getRealClass((Object)this.serviceBean);
        }
        return this.getServiceFactory().getServiceClass();
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setWsdlLocation(String location) {
        this.setWsdlURL(location);
    }

    public String getWsdlLocation() {
        return this.getWsdlURL();
    }
}

