/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.w3c.dom.Element;

public class SpnegoContextToken
extends Token {
    private Element issuerEpr;

    public SpnegoContextToken(SPConstants version) {
        super(version);
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getSpnegoContextToken();
    }

    public Element getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(Element issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String inclusion;
        String prefix;
        QName name = this.constants.getSpnegoContextToken();
        String localname = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = name.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, "Issuer", namespaceURI);
            StaxUtils.copy(this.issuerEpr, writer);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys()) {
            String wspPrefix;
            String wspNamespaceURI = SPConstants.POLICY.getNamespaceURI();
            String wspWriterPrefix = writer.getPrefix(wspNamespaceURI);
            if (wspWriterPrefix == null) {
                wspPrefix = SPConstants.POLICY.getPrefix();
                writer.setPrefix(wspPrefix, wspNamespaceURI);
            } else {
                wspPrefix = wspWriterPrefix;
            }
            writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), wspNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, wspNamespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

