/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.servlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFNonSpringJaxrsServlet
extends CXFNonSpringServlet {
    private static final long serialVersionUID = -8916352798780577499L;
    private static final Logger LOG;
    private static final String USER_MODEL_PARAM = "user.model";
    private static final String SERVICE_ADDRESS_PARAM = "jaxrs.address";
    private static final String IGNORE_APP_PATH_PARAM = "jaxrs.application.address.ignore";
    private static final String SERVICE_CLASSES_PARAM = "jaxrs.serviceClasses";
    private static final String PROVIDERS_PARAM = "jaxrs.providers";
    private static final String OUT_INTERCEPTORS_PARAM = "jaxrs.outInterceptors";
    private static final String OUT_FAULT_INTERCEPTORS_PARAM = "jaxrs.outFaultInterceptors";
    private static final String IN_INTERCEPTORS_PARAM = "jaxrs.inInterceptors";
    private static final String INVOKER_PARAM = "jaxrs.invoker";
    private static final String SERVICE_SCOPE_PARAM = "jaxrs.scope";
    private static final String EXTENSIONS_PARAM = "jaxrs.extensions";
    private static final String LANGUAGES_PARAM = "jaxrs.languages";
    private static final String PROPERTIES_PARAM = "jaxrs.properties";
    private static final String SCHEMAS_PARAM = "jaxrs.schemaLocations";
    private static final String DOC_LOCATION_PARAM = "jaxrs.documentLocation";
    private static final String STATIC_SUB_RESOLUTION_PARAM = "jaxrs.static.subresources";
    private static final String SERVICE_SCOPE_SINGLETON = "singleton";
    private static final String SERVICE_SCOPE_REQUEST = "prototype";
    private static final String PARAMETER_SPLIT_CHAR = "class.parameter.split.char";
    private static final String DEFAULT_PARAMETER_SPLIT_CHAR = ",";
    private static final String SPACE_PARAMETER_SPLIT_CHAR = "space";
    private static final String JAXRS_APPLICATION_PARAM = "javax.ws.rs.Application";

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String splitChar = this.getParameterSplitChar(servletConfig);
        String applicationClass = servletConfig.getInitParameter(JAXRS_APPLICATION_PARAM);
        if (applicationClass != null) {
            this.createServerFromApplication(applicationClass, servletConfig, splitChar);
            return;
        }
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        bean.setBus(this.getBus());
        String address = servletConfig.getInitParameter(SERVICE_ADDRESS_PARAM);
        if (address == null) {
            address = "/";
        }
        bean.setAddress(address);
        bean.setStaticSubresourceResolution(this.getStaticSubResolutionValue(servletConfig));
        String modelRef = servletConfig.getInitParameter(USER_MODEL_PARAM);
        if (modelRef != null) {
            bean.setModelRef(modelRef.trim());
        }
        this.setDocLocation(bean, servletConfig);
        this.setSchemasLocations(bean, servletConfig);
        this.setAllInterceptors(bean, servletConfig, splitChar);
        this.setInvoker(bean, servletConfig);
        Map<Class<?>, Map<String, List<String>>> resourceClasses = this.getServiceClasses(servletConfig, modelRef != null, splitChar);
        Map<Class<?>, ResourceProvider> resourceProviders = this.getResourceProviders(servletConfig, resourceClasses);
        List<?> providers = this.getProviders(servletConfig, splitChar);
        bean.setResourceClasses(new ArrayList(resourceClasses.keySet()));
        bean.setProviders(providers);
        for (Map.Entry<Class<?>, ResourceProvider> entry : resourceProviders.entrySet()) {
            bean.setResourceProvider(entry.getKey(), entry.getValue());
        }
        this.setExtensions(bean, servletConfig);
        bean.create();
    }

    protected String getParameterSplitChar(ServletConfig servletConfig) {
        String param = servletConfig.getInitParameter(PARAMETER_SPLIT_CHAR);
        if (!StringUtils.isEmpty(param) && SPACE_PARAMETER_SPLIT_CHAR.equals(param.trim())) {
            return " ";
        }
        return DEFAULT_PARAMETER_SPLIT_CHAR;
    }

    protected boolean getStaticSubResolutionValue(ServletConfig servletConfig) {
        String param = servletConfig.getInitParameter(STATIC_SUB_RESOLUTION_PARAM);
        if (param != null) {
            return Boolean.valueOf(param.trim());
        }
        return false;
    }

    protected void setExtensions(JAXRSServerFactoryBean bean, ServletConfig servletConfig) {
        bean.setExtensionMappings(CastUtils.cast(CXFNonSpringJaxrsServlet.parseMapSequence(servletConfig.getInitParameter(EXTENSIONS_PARAM))));
        bean.setLanguageMappings(CastUtils.cast(CXFNonSpringJaxrsServlet.parseMapSequence(servletConfig.getInitParameter(LANGUAGES_PARAM))));
        bean.setProperties(CastUtils.cast(CXFNonSpringJaxrsServlet.parseMapSequence(servletConfig.getInitParameter(PROPERTIES_PARAM)), String.class, Object.class));
    }

    protected void setAllInterceptors(JAXRSServerFactoryBean bean, ServletConfig servletConfig, String splitChar) throws ServletException {
        this.setInterceptors(bean, servletConfig, OUT_INTERCEPTORS_PARAM, splitChar);
        this.setInterceptors(bean, servletConfig, OUT_FAULT_INTERCEPTORS_PARAM, splitChar);
        this.setInterceptors(bean, servletConfig, IN_INTERCEPTORS_PARAM, splitChar);
    }

    protected void setSchemasLocations(JAXRSServerFactoryBean bean, ServletConfig servletConfig) {
        String schemas = servletConfig.getInitParameter(SCHEMAS_PARAM);
        if (schemas == null) {
            return;
        }
        String[] locations = schemas.split(" ");
        ArrayList<String> list = new ArrayList<String>();
        for (String loc : locations) {
            String theLoc = loc.trim();
            if (theLoc.length() == 0) continue;
            list.add(theLoc);
        }
        if (list.size() > 0) {
            bean.setSchemaLocations(list);
        }
    }

    protected void setDocLocation(JAXRSServerFactoryBean bean, ServletConfig servletConfig) {
        String wadlLoc = servletConfig.getInitParameter(DOC_LOCATION_PARAM);
        if (wadlLoc != null) {
            bean.setDocLocation(wadlLoc);
        }
    }

    protected void setInterceptors(JAXRSServerFactoryBean bean, ServletConfig servletConfig, String paramName, String splitChar) throws ServletException {
        String value = servletConfig.getInitParameter(paramName);
        if (value == null) {
            return;
        }
        String[] values = value.split(splitChar);
        ArrayList<Interceptor<? extends Message>> list = new ArrayList<Interceptor<? extends Message>>();
        for (String interceptorVal : values) {
            HashMap<String, List<String>> props = new HashMap<String, List<String>>();
            String theValue = this.getClassNameAndProperties(interceptorVal, props);
            if (theValue.length() == 0) continue;
            try {
                Class<?> intClass = this.loadClass(theValue, "Interceptor");
                Object object = intClass.newInstance();
                this.injectProperties(object, props);
                list.add((Interceptor)object);
            }
            catch (ServletException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.warning("Interceptor class " + theValue + " can not be created");
                throw new ServletException((Throwable)ex);
            }
        }
        if (list.size() > 0) {
            if (OUT_INTERCEPTORS_PARAM.equals(paramName)) {
                bean.setOutInterceptors(list);
            } else if (OUT_FAULT_INTERCEPTORS_PARAM.equals(paramName)) {
                bean.setOutFaultInterceptors(list);
            } else {
                bean.setInInterceptors(list);
            }
        }
    }

    protected void setInvoker(JAXRSServerFactoryBean bean, ServletConfig servletConfig) throws ServletException {
        String value = servletConfig.getInitParameter(INVOKER_PARAM);
        if (value == null) {
            return;
        }
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        String theValue = this.getClassNameAndProperties(value, props);
        if (theValue.length() != 0) {
            try {
                Class<?> intClass = this.loadClass(theValue, "Invoker");
                Object object = intClass.newInstance();
                this.injectProperties(object, props);
                bean.setInvoker((Invoker)object);
            }
            catch (ServletException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.warning("Invoker class " + theValue + " can not be created");
                throw new ServletException((Throwable)ex);
            }
        }
    }

    protected Map<Class<?>, Map<String, List<String>>> getServiceClasses(ServletConfig servletConfig, boolean modelAvailable, String splitChar) throws ServletException {
        String serviceBeans = servletConfig.getInitParameter(SERVICE_CLASSES_PARAM);
        if (serviceBeans == null) {
            if (modelAvailable) {
                return Collections.emptyMap();
            }
            throw new ServletException("At least one resource class should be specified");
        }
        String[] classNames = serviceBeans.split(splitChar);
        HashMap map = new HashMap();
        for (String cName : classNames) {
            HashMap<String, List<String>> props = new HashMap<String, List<String>>();
            String theName = this.getClassNameAndProperties(cName, props);
            if (theName.length() == 0) continue;
            Class<?> cls = this.loadClass(theName);
            map.put(cls, props);
        }
        if (map.isEmpty()) {
            throw new ServletException("At least one resource class should be specified");
        }
        return map;
    }

    protected List<?> getProviders(ServletConfig servletConfig, String splitChar) throws ServletException {
        String providersList = servletConfig.getInitParameter(PROVIDERS_PARAM);
        if (providersList == null) {
            return Collections.EMPTY_LIST;
        }
        String[] classNames = providersList.split(splitChar);
        ArrayList<Object> providers = new ArrayList<Object>();
        for (String cName : classNames) {
            HashMap<String, List<String>> props = new HashMap<String, List<String>>();
            String theName = this.getClassNameAndProperties(cName, props);
            if (theName.length() == 0) continue;
            Class<?> cls = this.loadClass(theName);
            providers.add(this.createSingletonInstance(cls, props, servletConfig));
        }
        return providers;
    }

    private String getClassNameAndProperties(String cName, Map<String, List<String>> props) {
        String theName = cName.trim();
        int ind = theName.indexOf("(");
        if (ind != -1 && theName.endsWith(")")) {
            props.putAll(CXFNonSpringJaxrsServlet.parseMapListSequence(theName.substring(ind + 1, theName.length() - 1)));
            theName = theName.substring(0, ind).trim();
        }
        return theName;
    }

    protected static Map<String, List<String>> parseMapListSequence(String sequence) {
        if (sequence != null) {
            String[] pairs;
            sequence = sequence.trim();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (String pair : pairs = sequence.split(" ")) {
                String value;
                String key;
                String thePair = pair.trim();
                if (thePair.length() == 0) continue;
                String[] values = thePair.split("=");
                if (values.length == 2) {
                    key = values[0].trim();
                    value = values[1].trim();
                } else {
                    key = thePair;
                    value = "";
                }
                LinkedList<String> list = (LinkedList<String>)map.get(key);
                if (list == null) {
                    list = new LinkedList<String>();
                    map.put(key, list);
                }
                list.add(value);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    protected Map<Class<?>, ResourceProvider> getResourceProviders(ServletConfig servletConfig, Map<Class<?>, Map<String, List<String>>> resourceClasses) throws ServletException {
        String scope = servletConfig.getInitParameter(SERVICE_SCOPE_PARAM);
        if (scope != null && !SERVICE_SCOPE_SINGLETON.equals(scope) && !SERVICE_SCOPE_REQUEST.equals(scope)) {
            throw new ServletException("Only singleton and prototype scopes are supported");
        }
        boolean isPrototype = SERVICE_SCOPE_REQUEST.equals(scope);
        HashMap map = new HashMap();
        for (Map.Entry<Class<?>, Map<String, List<String>>> entry : resourceClasses.entrySet()) {
            Class<?> c = entry.getKey();
            map.put(c, isPrototype ? new PerRequestResourceProvider(c) : new SingletonResourceProvider(this.createSingletonInstance(c, entry.getValue(), servletConfig), true));
        }
        return map;
    }

    protected Object createSingletonInstance(Class<?> cls, Map<String, List<String>> props, ServletConfig sc) throws ServletException {
        Object[] objectArray;
        boolean isDefault;
        Constructor<?> c = ResourceUtils.findResourceConstructor(cls, false);
        if (c == null) {
            throw new ServletException("No valid constructor found for " + cls.getName());
        }
        boolean bl = isDefault = c.getParameterTypes().length == 0;
        if (!isDefault && (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != ServletConfig.class && c.getParameterTypes()[0] != ServletContext.class)) {
            throw new ServletException("Resource classes with singleton scope can only have ServletConfig or ServletContext instances injected through their constructors");
        }
        if (isDefault) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = c.getParameterTypes()[0] == ServletConfig.class ? sc : sc.getServletContext();
        }
        Object[] values = objectArray;
        try {
            Object instance = c.newInstance(values);
            this.injectProperties(instance, props);
            this.configureSingleton(instance);
            return instance;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated");
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated due to IllegalAccessException");
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated due to InvocationTargetException");
        }
    }

    private void injectProperties(Object instance, Map<String, List<String>> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        Method[] methods = instance.getClass().getMethods();
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        for (Method m : methods) {
            methodsMap.put(m.getName(), m);
        }
        for (Map.Entry<String, List<String>> entry : props.entrySet()) {
            Method m = (Method)methodsMap.get("set" + Character.toUpperCase(entry.getKey().charAt(0)) + entry.getKey().substring(1));
            if (m == null) continue;
            Class<?> type = m.getParameterTypes()[0];
            Object value = InjectionUtils.isPrimitive(type) ? PrimitiveUtils.read(entry.getValue().get(0), type) : entry.getValue();
            InjectionUtils.injectThroughMethod(instance, m, value);
        }
    }

    protected void configureSingleton(Object instance) {
    }

    protected void createServerFromApplication(String cName, ServletConfig servletConfig, String splitChar) throws ServletException {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        cName = this.getClassNameAndProperties(cName, props);
        Class<?> appClass = this.loadClass(cName, "Application");
        Application app = (Application)this.createSingletonInstance(appClass, props, servletConfig);
        String ignoreParam = servletConfig.getInitParameter(IGNORE_APP_PATH_PARAM);
        JAXRSServerFactoryBean bean = ResourceUtils.createApplication(app, MessageUtils.isTrue(ignoreParam), this.getStaticSubResolutionValue(servletConfig));
        this.setAllInterceptors(bean, servletConfig, splitChar);
        this.setInvoker(bean, servletConfig);
        this.setExtensions(bean, servletConfig);
        this.setDocLocation(bean, servletConfig);
        this.setSchemasLocations(bean, servletConfig);
        bean.setBus(this.getBus());
        bean.create();
    }

    private Class<?> loadClass(String cName) throws ServletException {
        return this.loadClass(cName, "Resource");
    }

    private Class<?> loadClass(String cName, String classType) throws ServletException {
        try {
            return ClassLoaderUtils.loadClass(cName, CXFNonSpringJaxrsServlet.class);
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException("No " + classType + " class " + cName.trim() + " can be found", (Throwable)ex);
        }
    }

    static {
        RuntimeDelegateImpl runtimeDelegate = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
        LOG = LogUtils.getL7dLogger(CXFNonSpringJaxrsServlet.class);
    }
}

