/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLPrinterVisitor<T>
extends AbstractSearchConditionVisitor<T, String> {
    private StringBuilder sb;
    private String table;
    private String tableAlias;
    private List<String> columns;

    public SQLPrinterVisitor() {
        this(null, null, Collections.emptyList());
    }

    public SQLPrinterVisitor(String table, String ... columns) {
        this(null, table, Arrays.asList(columns));
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, List<String> columns) {
        this(fieldMap, table, null, columns);
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, String tableAlias, List<String> columns) {
        super(fieldMap);
        this.columns = columns;
        this.table = table;
        this.tableAlias = tableAlias;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        if (this.sb == null) {
            this.sb = new StringBuilder();
            if (this.table != null) {
                SearchUtils.startSqlQuery(this.sb, this.table, this.tableAlias, this.columns);
            }
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                String rvalStr = statement.getValue().toString().replaceAll("\\*", "%");
                String name = this.getRealPropertyName(statement.getProperty());
                if (this.tableAlias != null) {
                    name = this.tableAlias + "." + name;
                }
                this.sb.append(name).append(" ").append(SearchUtils.conditionTypeToSqlOperator(sc.getConditionType(), rvalStr)).append(" ").append("'").append(rvalStr).append("'");
            }
        } else {
            boolean first = true;
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                if (!first) {
                    this.sb.append(" ").append(sc.getConditionType().toString()).append(" ");
                } else {
                    first = false;
                }
                this.sb.append("(");
                condition.accept(this);
                this.sb.append(")");
            }
        }
    }

    @Deprecated
    public String getResult() {
        return this.getQuery();
    }

    @Override
    public String getQuery() {
        return this.sb == null ? null : this.sb.toString();
    }
}

