/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.ldap;

import java.util.Collections;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapQueryVisitor<T>
extends AbstractSearchConditionVisitor<T, String> {
    private StringBuilder sb = new StringBuilder();

    public LdapQueryVisitor() {
        this(Collections.emptyMap());
    }

    public LdapQueryVisitor(Map<String, String> fieldMap) {
        super(fieldMap);
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                String rvalStr = statement.getValue().toString();
                String name = this.getRealPropertyName(statement.getProperty());
                this.sb.append("(");
                if (sc.getConditionType() == ConditionType.NOT_EQUALS) {
                    this.sb.append("!");
                }
                String ldapOperator = LdapQueryVisitor.conditionTypeToLdapOperator(sc.getConditionType());
                this.sb.append(name).append(ldapOperator).append(rvalStr);
                this.sb.append(")");
            }
        } else {
            this.sb.append("(");
            if (sc.getConditionType() == ConditionType.AND) {
                this.sb.append("&");
            } else {
                this.sb.append("|");
            }
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            this.sb.append(")");
        }
    }

    @Override
    public String getQuery() {
        return this.sb.toString();
    }

    public static String conditionTypeToLdapOperator(ConditionType ct) {
        String op;
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                op = "=";
                break;
            }
            case GREATER_THAN: 
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: 
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }
}

