/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.client;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.datatype.Duration;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.cxf.jaxrs.ext.search.client.PartialCondition;
import org.apache.cxf.jaxrs.ext.search.client.Property;
import org.apache.cxf.jaxrs.ext.search.client.SearchConditionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiqlSearchConditionBuilder
extends SearchConditionBuilder {
    private Map<String, String> properties;

    public FiqlSearchConditionBuilder() {
        this(Collections.emptyMap());
    }

    public FiqlSearchConditionBuilder(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String query() {
        return "";
    }

    @Override
    public Property is(String property) {
        return new Builder(this.properties).is(property);
    }

    @Override
    public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return new Builder(this.properties).and(c1, c2, cn);
    }

    @Override
    public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return new Builder(this.properties).or(c1, c2, cn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Builder
    implements Property,
    CompleteCondition,
    PartialCondition {
        private String result = "";
        private Builder parent;
        private DateFormat df;
        private boolean timeZoneSupported;

        public Builder(Map<String, String> properties) {
            this.parent = null;
            this.df = SearchUtils.getDateFormat(properties);
            this.timeZoneSupported = SearchUtils.isTimeZoneSupported(properties, Boolean.FALSE);
        }

        public Builder(Builder parent) {
            this.parent = parent;
            this.df = parent.getDateFormat();
            this.timeZoneSupported = parent.isTimeZoneSupported();
        }

        @Override
        public String query() {
            return this.buildPartial(null);
        }

        private DateFormat getDateFormat() {
            return this.df;
        }

        private boolean isTimeZoneSupported() {
            return this.timeZoneSupported;
        }

        private String buildPartial(Builder exclude) {
            if (this.parent != null && !this.parent.equals(exclude)) {
                return this.parent.buildPartial(exclude) + this.result;
            }
            return this.result;
        }

        @Override
        public CompleteCondition after(Date date) {
            return this.condition("=gt=", this.toString(date));
        }

        @Override
        public CompleteCondition before(Date date) {
            return this.condition("=lt=", this.toString(date));
        }

        @Override
        public CompleteCondition equalTo(String literalOrPattern) {
            return this.condition("==", literalOrPattern);
        }

        @Override
        public CompleteCondition equalTo(double number) {
            return this.condition("==", number);
        }

        @Override
        public CompleteCondition equalTo(long number) {
            return this.condition("==", number);
        }

        @Override
        public CompleteCondition equalTo(Date date) {
            return this.condition("==", this.toString(date));
        }

        @Override
        public CompleteCondition greaterOrEqualTo(double number) {
            return this.condition("=ge=", number);
        }

        @Override
        public CompleteCondition greaterOrEqualTo(long number) {
            return this.condition("=ge=", number);
        }

        @Override
        public CompleteCondition greaterThan(double number) {
            return this.condition("=gt=", number);
        }

        @Override
        public CompleteCondition greaterThan(long number) {
            return this.condition("=gt=", number);
        }

        @Override
        public CompleteCondition lessOrEqualTo(double number) {
            return this.condition("=le=", number);
        }

        @Override
        public CompleteCondition lessOrEqualTo(long number) {
            return this.condition("=le=", number);
        }

        @Override
        public CompleteCondition lessThan(double number) {
            return this.condition("=lt=", number);
        }

        @Override
        public CompleteCondition lessThan(long number) {
            return this.condition("=lt=", number);
        }

        @Override
        public CompleteCondition lexicalAfter(String literal) {
            return this.condition("=gt=", literal);
        }

        @Override
        public CompleteCondition lexicalBefore(String literal) {
            return this.condition("=lt=", literal);
        }

        @Override
        public CompleteCondition lexicalNotAfter(String literal) {
            return this.condition("=le=", literal);
        }

        @Override
        public CompleteCondition lexicalNotBefore(String literal) {
            return this.condition("=ge=", literal);
        }

        @Override
        public CompleteCondition notAfter(Date date) {
            return this.condition("=le=", this.toString(date));
        }

        @Override
        public CompleteCondition notBefore(Date date) {
            return this.condition("=ge=", this.toString(date));
        }

        @Override
        public CompleteCondition notEqualTo(String literalOrPattern) {
            return this.condition("!=", literalOrPattern);
        }

        @Override
        public CompleteCondition notEqualTo(double number) {
            return this.condition("!=", number);
        }

        @Override
        public CompleteCondition notEqualTo(long number) {
            return this.condition("!=", number);
        }

        @Override
        public CompleteCondition notEqualTo(Date date) {
            return this.condition("!=", this.toString(date));
        }

        @Override
        public CompleteCondition after(Duration distanceFromNow) {
            return this.condition("=gt=", distanceFromNow);
        }

        @Override
        public CompleteCondition before(Duration distanceFromNow) {
            return this.condition("=lt=", distanceFromNow);
        }

        @Override
        public CompleteCondition equalTo(Duration distanceFromNow) {
            return this.condition("==", distanceFromNow);
        }

        @Override
        public CompleteCondition notAfter(Duration distanceFromNow) {
            return this.condition("=le=", distanceFromNow);
        }

        @Override
        public CompleteCondition notBefore(Duration distanceFromNow) {
            return this.condition("=ge=", distanceFromNow);
        }

        @Override
        public CompleteCondition notEqualTo(Duration distanceFromNow) {
            return this.condition("!=", distanceFromNow);
        }

        protected CompleteCondition condition(String operator, Object value) {
            this.result = this.result + operator + value;
            return this;
        }

        @Override
        public PartialCondition and() {
            this.result = this.result + ";";
            return this;
        }

        @Override
        public Property and(String name) {
            return this.and().is(name);
        }

        @Override
        public PartialCondition or() {
            this.result = this.result + ",";
            return this;
        }

        @Override
        public Property or(String name) {
            return this.or().is(name);
        }

        @Override
        public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + ";" + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + ";" + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + "," + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + "," + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public Property is(String property) {
            Builder b = new Builder(this);
            b.result = property;
            return b;
        }

        private String toString(Date date) {
            String s = this.df.format(date);
            if (this.timeZoneSupported) {
                int len = s.length();
                return s.substring(0, len - 2) + ":" + s.substring(len - 2, len);
            }
            return s;
        }
    }
}

