/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;

public class RetransmissionCallback
implements CachedOutputStreamCallback {
    Message message;
    RMManager manager;

    RetransmissionCallback(Message m, RMManager mgr) {
        this.message = m;
        this.manager = mgr;
    }

    public void onClose(CachedOutputStream cos) {
        CachedOutputStream saved = new CachedOutputStream();
        saved.holdTempFile();
        try {
            cos.writeCacheTo(saved);
            saved.lockOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.message.put("org.apache.cxf.ws.rm.content", saved);
        this.manager.getRetransmissionQueue().addUnacknowledged(this.message);
        RMStore store = this.manager.getStore();
        if (null != store) {
            try {
                AddressingProperties maps;
                Source s = this.manager.getSource(this.message);
                RMProperties rmps = RMContextUtils.retrieveRMProperties(this.message, true);
                Identifier sid = rmps.getSequence().getIdentifier();
                SourceSequence ss = s.getSequence(sid);
                RMMessage msg = new RMMessage();
                msg.setMessageNumber(rmps.getSequence().getMessageNumber());
                if (!MessageUtils.isRequestor(this.message) && null != (maps = RMContextUtils.retrieveMAPs(this.message, false, true)) && null != maps.getTo()) {
                    msg.setTo(maps.getTo().getValue());
                }
                msg.setContent(saved);
                store.persistOutgoing(ss, msg);
            }
            catch (RMException rMException) {
                // empty catch block
            }
        }
    }

    public void onFlush(CachedOutputStream cos) {
    }
}

