/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Conduit;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final WSDLGetInterceptor INSTANCE = new WSDLGetInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);

    public WSDLGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    public void doOutput(Message message, String base, Document doc, OutputStream out) throws WSDLQueryException {
        String enc = null;
        try {
            enc = doc.getXmlEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enc == null) {
            enc = "utf-8";
        }
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(out, enc);
        try {
            StaxUtils.writeNode(doc, writer, true);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, base), (Throwable)e);
        }
        finally {
            StaxUtils.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) throws Fault {
        block18: {
            String method = (String)message.get("org.apache.cxf.request.method");
            String query = (String)message.get(Message.QUERY_STRING);
            if (!"GET".equals(method) || StringUtils.isEmpty(query)) {
                return;
            }
            String baseUri = (String)message.get("org.apache.cxf.request.url");
            String ctx = (String)message.get(Message.PATH_INFO);
            boolean setOutMessageToNull = false;
            try {
                CachedOutputStream cos = null;
                Endpoint endpoint = message.getExchange().getEndpoint();
                synchronized (endpoint) {
                    Map<String, String> map = UrlUtils.parseQueryString(query);
                    if (this.isRecognizedQuery(map, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
                        setOutMessageToNull = true;
                        try {
                            Document doc = this.getDocument(message, baseUri, map, ctx, message.getExchange().getEndpoint().getEndpointInfo());
                            String enc = null;
                            try {
                                enc = doc.getXmlEncoding();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (enc == null) {
                                enc = "utf-8";
                            }
                            cos = new CachedOutputStream();
                            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(cos, enc);
                            StaxUtils.writeNode(doc, writer, true);
                            writer.flush();
                            writer.close();
                        }
                        catch (XMLStreamException e) {
                            throw new Fault(e);
                        }
                    }
                }
                if (cos == null) break block18;
                try {
                    Conduit c = message.getExchange().getDestination().getBackChannel(message, null, null);
                    MessageImpl mout = new MessageImpl();
                    mout.setExchange(message.getExchange());
                    message.getExchange().setOutMessage(mout);
                    mout.put("Content-Type", "text/xml");
                    c.prepare(mout);
                    OutputStream os = mout.getContent(OutputStream.class);
                    InputStream cis = cos.getInputStream();
                    IOUtils.copyAndCloseInput(cis, os);
                    message.getInterceptorChain().abort();
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Failure writing full wsdl to the stream", ex);
                    }
                    cos.close();
                }
                catch (IOException e) {
                    throw new Fault(e);
                }
            }
            finally {
                if (setOutMessageToNull) {
                    message.getExchange().setOutMessage(null);
                }
            }
        }
    }

    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        return new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
    }

    public boolean isRecognizedQuery(Map<String, String> map, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }
}

