/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import org.apache.cxf.bus.blueprint.BlueprintBeanLocator;
import org.apache.cxf.bus.blueprint.BundleDelegatingClassLoader;
import org.apache.cxf.bus.blueprint.ConfigurerImpl;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.WrappedFeature;
import org.apache.cxf.resource.ClassLoaderResolver;
import org.apache.cxf.resource.ResourceManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class BlueprintBus
extends ExtensionManagerBus {
    BundleContext context;
    BlueprintContainer container;

    public BlueprintBus() {
        super(null, null, BlueprintBus.class.getClassLoader());
    }

    public void loadAdditionalFeatures() {
        super.loadAdditionalFeatures();
        try {
            ServiceReference[] refs = this.context.getServiceReferences(Feature.class.getName(), null);
            if (refs == null) {
                return;
            }
            for (ServiceReference ref : refs) {
                Feature feature = (Feature)this.context.getService(ref);
                if (feature instanceof AbstractFeature) {
                    this.getFeatures().add((AbstractFeature)feature);
                    continue;
                }
                this.getFeatures().add(new WrappedFeature(feature));
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void setBundleContext(BundleContext c) {
        this.context = c;
        BundleDelegatingClassLoader bundleClassLoader = new BundleDelegatingClassLoader(c.getBundle(), this.getClass().getClassLoader());
        super.setExtension(bundleClassLoader, ClassLoader.class);
        ResourceManager rm = super.getExtension(ResourceManager.class);
        rm.addResourceResolver(new ClassLoaderResolver(bundleClassLoader));
        super.setExtension(c, BundleContext.class);
    }

    public void setBlueprintContainer(BlueprintContainer con) {
        this.container = con;
        this.setExtension(new ConfigurerImpl(con), Configurer.class);
        this.setExtension(new BlueprintBeanLocator(this.getExtension(ConfiguredBeanLocator.class), this.container, this.context), ConfiguredBeanLocator.class);
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.context.getBundle().getSymbolicName() + "-" + "cxf" + Integer.toString(this.hashCode());
        }
        return this.id;
    }
}

