/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHCacheTokenStore
implements TokenStore {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    public static final int MAX_ELEMENTS = 1000000;
    private Cache cache;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheTokenStore(String key, URL configFileURL) {
        if (this.cacheManager == null) {
            this.cacheManager = configFileURL == null ? CacheManager.create() : CacheManager.create((URL)configFileURL);
        }
        if (!this.cacheManager.cacheExists(key)) {
            this.cache = new Cache(key, 1000000, false, false, 3600L, 3600L);
            this.cacheManager.addCache(this.cache);
        } else {
            this.cache = this.cacheManager.getCache(key);
        }
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public void add(SecurityToken token) {
        int parsedTTL;
        if (token != null && !StringUtils.isEmpty(token.getId()) && (parsedTTL = this.getTTL(token)) > 0) {
            this.cache.put(new Element((Object)token.getId(), (Object)token, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL)));
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        int parsedTTL;
        if (token != null && !StringUtils.isEmpty(identifier) && (parsedTTL = this.getTTL(token)) > 0) {
            this.cache.put(new Element((Object)identifier, (Object)token, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL)));
        }
    }

    @Override
    public void remove(String identifier) {
        if (!StringUtils.isEmpty(identifier) && this.cache.isKeyInCache((Object)identifier)) {
            this.cache.remove((Serializable)((Object)identifier));
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        return this.cache.getKeysWithExpiryCheck();
    }

    @Override
    public Collection<SecurityToken> getExpiredTokens() {
        ArrayList<SecurityToken> expiredTokens = new ArrayList<SecurityToken>();
        Iterator ids = this.cache.getKeys().iterator();
        while (ids.hasNext()) {
            Element element = this.cache.get((Serializable)ids.next());
            if (!this.cache.isExpired(element)) continue;
            expiredTokens.add((SecurityToken)element.getObjectValue());
        }
        return expiredTokens;
    }

    @Override
    public SecurityToken getToken(String identifier) {
        Element element = this.cache.get((Serializable)((Object)identifier));
        if (element != null && !this.cache.isExpired(element)) {
            return (SecurityToken)element.getObjectValue();
        }
        return null;
    }

    private int getTTL(SecurityToken token) {
        int parsedTTL = 0;
        if (token.getExpires() != null) {
            Date expires = token.getExpires();
            Date current = new Date();
            long expiryTime = (expires.getTime() - current.getTime()) / 1000L;
            if (expiryTime < 0L) {
                return 0;
            }
            parsedTTL = (int)expiryTime;
            if ((expiryTime != (long)parsedTTL || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
                parsedTTL = 3600;
            }
        } else {
            parsedTTL = (int)this.ttl;
            if (this.ttl != (long)parsedTTL) {
                parsedTTL = 3600;
            }
        }
        return parsedTTL;
    }
}

