/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Fault;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.model.JavaClass;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.BeanGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.FaultBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FaultBeanGenerator
extends BeanGenerator {
    private String getSEIPackage(Method method) {
        String pkg = PackageUtils.getPackageName(method.getDeclaringClass());
        if (pkg.length() == 0) {
            return "defaultnamespace";
        }
        return pkg;
    }

    @Override
    protected Collection<JavaClass> generateBeanClasses(ServiceInfo serviceInfo) {
        HashSet exceptionClasses = new HashSet();
        String seiPackageName = null;
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            Method method = (Method)op.getProperty("operation.method");
            exceptionClasses.addAll(this.getExceptionClasses(method));
            seiPackageName = this.getSEIPackage(method);
        }
        HashSet<JavaClass> faultBeanClasses = new HashSet<JavaClass>();
        String defaultPackage = seiPackageName + ".jaxws";
        FaultBean bean = new FaultBean();
        for (Class clazz : exceptionClasses) {
            if (bean.faultBeanExists(clazz)) continue;
            faultBeanClasses.add(bean.transform(clazz, defaultPackage));
        }
        return faultBeanClasses;
    }

    protected Set<Class<?>> getExceptionClasses(Method method) {
        HashSet exps = new HashSet();
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            Method[] expMethods;
            boolean exclude = false;
            Class<?> exClazz = exceptionClasses[i];
            if (exClazz.equals(Exception.class) || Fault.class.isAssignableFrom(exClazz) || exClazz.equals(RuntimeException.class) || exClazz.equals(Throwable.class) || exClazz.equals(RemoteException.class) || exClazz.equals(ServerException.class)) continue;
            for (Method expMethod : expMethods = exClazz.getMethods()) {
                if (!"getFaultInfo".equals(expMethod.getName())) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            exps.add(exClazz);
        }
        return exps;
    }
}

