/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.tools.corba.utils.OutputStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOutputStreamFactory
implements OutputStreamFactory {
    String dirName = "";
    List<String> fileNames;
    FileOutputStreamFactory parent;

    public FileOutputStreamFactory() {
        this.fileNames = new LinkedList<String>();
    }

    public FileOutputStreamFactory(String dir) {
        this(dir, null);
        this.fileNames = new LinkedList<String>();
    }

    public FileOutputStreamFactory(String dir, FileOutputStreamFactory p) {
        this.dirName = dir;
        if (this.dirName == null) {
            this.dirName = "";
        }
        if (!"".equals(this.dirName) && !".".equals(this.dirName)) {
            if (!this.dirName.endsWith(File.separator)) {
                this.dirName = this.dirName + File.separator;
            }
            File file = new File(this.dirName);
            file.mkdirs();
        }
        this.parent = p;
    }

    public String getDirectoryName() {
        return this.dirName;
    }

    private void addFileName(String name) {
        this.fileNames.add(name);
        if (this.parent != null) {
            this.parent.addFileName(name);
        }
    }

    private String getClassDirectory(String packageName) {
        String result = this.convertPackageNameToDirectory(packageName);
        if (!".".equals(this.dirName)) {
            result = this.dirName + result;
        }
        return result;
    }

    private String convertPackageNameToDirectory(String packageName) {
        String result = "";
        int pos1 = 0;
        int pos2 = packageName.indexOf(".", pos1);
        while (pos2 != -1) {
            result = result + packageName.substring(pos1, pos2) + File.separator;
            pos1 = pos2 + 1;
            pos2 = packageName.indexOf(".", pos1);
        }
        result = result + packageName.substring(pos1);
        return result;
    }

    @Override
    public OutputStream createFakeOutputStream(String name) throws IOException {
        this.addFileName(name);
        return new ByteArrayOutputStream();
    }

    @Override
    public OutputStream createFakeOutputStream(String packageName, String name) throws IOException {
        String packageDirName = this.convertPackageNameToDirectory(packageName);
        if (!"".equals(packageDirName) && !packageDirName.endsWith(File.separator)) {
            packageDirName = packageDirName + File.separator;
        }
        this.addFileName(packageDirName + name);
        return new ByteArrayOutputStream();
    }

    @Override
    public OutputStream createOutputStream(String packageName, String name) throws IOException {
        String packageDirName = this.convertPackageNameToDirectory(packageName);
        if (!"".equals(packageDirName) && !packageDirName.endsWith(File.separator)) {
            packageDirName = packageDirName + File.separator;
        }
        String dname = packageDirName;
        if (!".".equals(this.dirName)) {
            dname = this.dirName + packageDirName;
        }
        if (!"".equals(dname) && !".".equals(dname)) {
            File file = new File(dname);
            file.mkdirs();
        }
        this.addFileName(packageDirName + name);
        return new FileOutputStream(dname + name);
    }

    @Override
    public OutputStream createOutputStream(String name) throws IOException {
        this.addFileName(name);
        String dname = name;
        if (!".".equals(this.dirName)) {
            dname = this.dirName + name;
        }
        return new FileOutputStream(dname);
    }

    @Override
    public OutputStreamFactory createSubpackageOutputStreamFactory(String name) throws IOException {
        String dname = name;
        if (!".".equals(this.dirName)) {
            dname = this.dirName + name;
        }
        return new FileOutputStreamFactory(dname, this);
    }

    @Override
    public Iterator<String> getStreamNames() throws IOException {
        return this.fileNames.iterator();
    }

    @Override
    public void clearStreams() {
        this.fileNames.clear();
        if (this.parent != null) {
            this.parent.clearStreams();
        }
    }

    @Override
    public boolean isOutputStreamExists(String packageName, String name) {
        String dname = this.getClassDirectory(packageName);
        if (!"".equals(dname) && !dname.endsWith(File.separator)) {
            dname = dname + File.separator;
        }
        File file = new File(dname + name);
        return file.exists();
    }
}

