/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorizationUtils {
    private AuthorizationUtils() {
    }

    public static String[] getBasicAuthParts(String data) {
        String authDecoded = null;
        try {
            authDecoded = new String(Base64Utility.decode(data));
        }
        catch (Exception ex) {
            throw new WebApplicationException(401);
        }
        String[] authInfo = authDecoded.split(":");
        if (authInfo.length == 2) {
            return authInfo;
        }
        throw new WebApplicationException(401);
    }

    public static String[] getAuthorizationParts(MessageContext mc) {
        return AuthorizationUtils.getAuthorizationParts(mc, Collections.singleton("Basic"));
    }

    public static String[] getAuthorizationParts(MessageContext mc, Set<String> challenges) {
        String[] parts;
        List headers = mc.getHttpHeaders().getRequestHeader("Authorization");
        if (headers.size() == 1 && (parts = ((String)headers.get(0)).split(" ")).length == 2) {
            return parts;
        }
        AuthorizationUtils.throwAuthorizationFailure(challenges);
        return null;
    }

    public static void throwAuthorizationFailure(Set<String> challenges) {
        StringBuilder sb = new StringBuilder();
        for (String challenge : challenges) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(challenge);
        }
        Response r = Response.status((int)401).header("WWW-Authenticate", (Object)sb.toString()).build();
        throw new WebApplicationException(r);
    }
}

