/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.primitive;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NestedPrimitiveAssertion
extends PrimitiveAssertion {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(NestedPrimitiveAssertion.class);
    private Policy nested;
    private boolean assertionRequired = true;
    private PolicyBuilder builder;

    @Deprecated
    public NestedPrimitiveAssertion(QName name, boolean optional) {
        this(name, optional, null, true, null);
    }

    public NestedPrimitiveAssertion(QName name, boolean optional, PolicyBuilder b) {
        this(name, optional, null, true, b);
    }

    public NestedPrimitiveAssertion(QName name, boolean optional, Policy p, boolean assertionRequired, PolicyBuilder b) {
        super(name, optional);
        this.assertionRequired = assertionRequired;
        this.nested = p;
        this.builder = b;
    }

    public NestedPrimitiveAssertion(Element elem, PolicyBuilder builder) {
        this(elem, builder, true);
    }

    public NestedPrimitiveAssertion(Element elem, PolicyBuilder builder, boolean assertionRequired) {
        super(elem);
        this.builder = builder;
        this.assertionRequired = assertionRequired;
        Element policyElem = null;
        for (Node nd = elem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType()) continue;
            QName qn = new QName(nd.getNamespaceURI(), nd.getLocalName());
            if (PolicyConstants.isPolicyElem(qn) && null == policyElem) {
                policyElem = (Element)nd;
                continue;
            }
            throw new PolicyException(new Message("UNEXPECTED_CHILD_ELEMENT_EXC", BUNDLE, "Policy"));
        }
        if (null == policyElem) {
            throw new PolicyException(new Message("UNEXPECTED_CHILD_ELEMENT_EXC", BUNDLE, "Policy"));
        }
        this.nested = builder.getPolicy(policyElem);
    }

    public PolicyComponent normalize() {
        Policy normalisedNested = (Policy)this.nested.normalize(this.builder == null ? null : this.builder.getPolicyRegistry(), true);
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        if (this.isOptional()) {
            ea.addPolicyComponent((PolicyComponent)new All());
        }
        Iterator alternatives = normalisedNested.getAlternatives();
        while (alternatives.hasNext()) {
            All all = new All();
            List<PolicyAssertion> alternative = CastUtils.cast((List)alternatives.next(), PolicyAssertion.class);
            NestedPrimitiveAssertion a = new NestedPrimitiveAssertion(this.getName(), false, this.builder);
            a.nested = new Policy();
            ExactlyOne nea = new ExactlyOne();
            a.nested.addPolicyComponent((PolicyComponent)nea);
            All na = new All();
            nea.addPolicyComponent((PolicyComponent)na);
            na.addPolicyComponents(alternative);
            all.addPolicyComponent((PolicyComponent)a);
            ea.addPolicyComponent((PolicyComponent)all);
        }
        return p;
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (!super.equal(policyComponent)) {
            return false;
        }
        NestedPrimitiveAssertion other = (NestedPrimitiveAssertion)policyComponent;
        return this.getPolicy().equal((PolicyComponent)other.getPolicy());
    }

    protected void setPolicy(Policy n) {
        this.nested = n;
    }

    public Policy getPolicy() {
        return this.nested;
    }

    public boolean isAsserted(AssertionInfoMap aim) {
        if (this.assertionRequired) {
            Collection<AssertionInfo> ail = aim.getAssertionInfo(this.name);
            for (AssertionInfo ai : ail) {
                if (!ai.isAsserted() || !this.isPolicyAsserted((PolicyOperator)this.nested, aim)) continue;
                return true;
            }
            return false;
        }
        return this.isPolicyAsserted((PolicyOperator)this.nested, aim);
    }

    protected boolean isPolicyAsserted(PolicyOperator p, AssertionInfoMap aim) {
        if (p == null) {
            return true;
        }
        List<PolicyComponent> pcs = CastUtils.cast(p.getPolicyComponents(), PolicyComponent.class);
        if (pcs.size() == 0) {
            return true;
        }
        if (pcs.get(0) instanceof PolicyAssertion) {
            List<PolicyAssertion> assertions = CastUtils.cast(pcs, PolicyAssertion.class);
            for (PolicyAssertion pa : assertions) {
                if (pa.isAsserted(aim)) continue;
                return false;
            }
            return true;
        }
        List<PolicyOperator> assertions = CastUtils.cast(pcs, PolicyOperator.class);
        for (PolicyOperator po : assertions) {
            if (!this.isPolicyAsserted(po, aim)) continue;
            return true;
        }
        return false;
    }
}

