/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;

public class DelegatingInputStream
extends FilterInputStream {
    private InputStream origIn;
    private boolean cached;

    public DelegatingInputStream(InputStream is) {
        super(is);
        this.origIn = is;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void close() throws IOException {
        super.close();
        if (this.in != this.origIn) {
            this.origIn.close();
        }
    }

    public void cacheInput() {
        if (!this.cached) {
            CachedOutputStream cache = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)this.in, (OutputStream)cache);
                if (cache.size() > 0) {
                    this.in = cache.getInputStream();
                }
                cache.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cached = true;
        }
    }
}

