/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.imaging.formats.tiff.constants;

public final class TiffDirectoryConstants {

    public static final int DIRECTORY_TYPE_UNKNOWN = -1;
    public static final int DIRECTORY_TYPE_ROOT = 0;
    public static final int DIRECTORY_TYPE_SUB = 1;
    public static final int DIRECTORY_TYPE_SUB0 = 1;
    public static final int DIRECTORY_TYPE_SUB1 = 2;
    public static final int DIRECTORY_TYPE_SUB2 = 3;
    public static final int DIRECTORY_TYPE_THUMBNAIL = 2;
    public static final int DIRECTORY_TYPE_EXIF = -2;
    public static final int DIRECTORY_TYPE_GPS = -3;
    public static final int DIRECTORY_TYPE_INTEROPERABILITY = -4;
    public static final int DIRECTORY_TYPE_MAKER_NOTES = -5;
    public static final int DIRECTORY_TYPE_DIR_0 = 0;
    public static final int DIRECTORY_TYPE_DIR_1 = 1;
    public static final int DIRECTORY_TYPE_DIR_2 = 2;
    public static final int DIRECTORY_TYPE_DIR_3 = 3;
    public static final int DIRECTORY_TYPE_DIR_4 = 4;

    // TODO: this should really be an enum
    private TiffDirectoryConstants() {
    }
}
