/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.activation.DataSource;

@Deprecated
public class ByteArrayDataSource
implements DataSource {
    private static final String CONTENT_TYPE = "application/octet-stream";
    public static final int BUFFER_SIZE = 512;
    private ByteArrayOutputStream outputStream;
    private final String contentType;
    private String name = "";

    public ByteArrayDataSource(byte[] data, String contentType) throws IOException {
        this.contentType = contentType;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            this.read(bis);
        }
    }

    public ByteArrayDataSource(InputStream inputStream, String contentType) throws IOException {
        this.contentType = contentType;
        this.read(inputStream);
    }

    public ByteArrayDataSource(String data, String contentType) throws IOException {
        this.contentType = contentType;
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.outputStream.write(data.getBytes(StandardCharsets.ISO_8859_1));
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("The Character Encoding is not supported.");
        }
        finally {
            this.outputStream.close();
        }
    }

    public String getContentType() {
        return this.contentType == null ? CONTENT_TYPE : this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.outputStream == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() {
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(InputStream inputStream) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream osWriter = null;
        try {
            int length = 0;
            byte[] buffer = new byte[512];
            bis = new BufferedInputStream(inputStream);
            this.outputStream = new ByteArrayOutputStream();
            osWriter = new BufferedOutputStream(this.outputStream);
            while ((length = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)osWriter).write(buffer, 0, length);
            }
            ((BufferedOutputStream)osWriter).flush();
            osWriter.close();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (osWriter != null) {
                osWriter.close();
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }
}

