/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import com.mockobjects.servlet.MockHttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.ServletRequestConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestServletRequestConfiguration
extends TestAbstractConfiguration {
    @Override
    protected AbstractConfiguration getConfiguration() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("key1", (Object)"value1");
        configuration.setProperty("key2", (Object)"value2");
        configuration.addProperty("list", (Object)"value1");
        configuration.addProperty("list", (Object)"value2");
        configuration.addProperty("listesc", (Object)"value1\\,value2");
        return this.createConfiguration((Configuration)configuration);
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        MockHttpServletRequest request = new MockHttpServletRequest(){

            public String getParameter(String key) {
                return null;
            }

            public Map<?, ?> getParameterMap() {
                return new HashMap();
            }
        };
        return new ServletRequestConfiguration((ServletRequest)request);
    }

    private ServletRequestConfiguration createConfiguration(final Configuration base) {
        MockHttpServletRequest request = new MockHttpServletRequest(){

            public String[] getParameterValues(String key) {
                return base.getStringArray(key);
            }

            public Map<?, ?> getParameterMap() {
                return new ConfigurationMap(base);
            }
        };
        ServletRequestConfiguration config = new ServletRequestConfiguration((ServletRequest)request);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return config;
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testAddPropertyDirect() {
        super.testAddPropertyDirect();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testClearProperty() {
        super.testClearProperty();
    }

    @Test
    public void testListWithEscapedElements() {
        String[] values = new String[]{"test1", "test2\\,test3", "test4\\,test5"};
        String listKey = "test.list";
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(listKey, (Object)values);
        Assert.assertEquals((String)"Wrong number of list elements", (long)values.length, (long)config.getList(listKey).size());
        ServletRequestConfiguration c = this.createConfiguration((Configuration)config);
        List v = c.getList(listKey);
        Assert.assertEquals((String)"Wrong number of elements in list", (long)values.length, (long)v.size());
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((String)("Wrong value at index " + i), (Object)values[i].replaceAll("\\\\", ""), v.get(i));
        }
    }
}

