/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationNodePointer
extends AbstractXPathTest {
    private ConfigurationNodePointer<ImmutableNode> pointer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.pointer = new ConfigurationNodePointer((Object)this.root, Locale.getDefault(), this.handler);
    }

    @Test
    public void testCompareChildNodePointersChildren() {
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, this.root.getChildren().get(1), this.handler);
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, this.root.getChildren().get(3), this.handler);
        Assert.assertEquals((String)"Incorrect order", (long)-1L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Incorrect symmetric order", (long)1L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testCompareChildNodePointersAttributes() {
        ImmutableNode n1 = new ImmutableNode.Builder().name("n1").create();
        ImmutableNode n2 = new ImmutableNode.Builder().name("n2").create();
        ConfigurationNodePointer p1 = new ConfigurationNodePointer(this.pointer, (Object)n1, this.handler);
        ConfigurationNodePointer p2 = new ConfigurationNodePointer(this.pointer, (Object)n2, this.handler);
        Assert.assertEquals((String)"Incorrect order", (long)0L, (long)this.pointer.compareChildNodePointers((NodePointer)p1, (NodePointer)p2));
        Assert.assertEquals((String)"Incorrect symmetric order", (long)0L, (long)this.pointer.compareChildNodePointers((NodePointer)p2, (NodePointer)p1));
    }

    @Test
    public void testIsAttribute() {
        Assert.assertFalse((String)"Node is an attribute", (boolean)this.pointer.isAttribute());
    }

    @Test
    public void testIsLeave() {
        Assert.assertFalse((String)"Root node is leaf", (boolean)this.pointer.isLeaf());
    }

    @Test
    public void testIsLeafTrue() {
        ImmutableNode leafNode = new ImmutableNode.Builder().name("leafNode").create();
        this.pointer = new ConfigurationNodePointer(this.pointer, (Object)leafNode, this.handler);
        Assert.assertTrue((String)"Not a leaf node", (boolean)this.pointer.isLeaf());
    }

    @Test
    public void testIterators() {
        this.checkIterators((NodePointer)this.pointer);
    }

    private void checkIterators(NodePointer p) {
        ImmutableNode node = (ImmutableNode)p.getNode();
        NodeIterator it = p.childIterator(null, false, null);
        Assert.assertEquals((String)"Iterator count differs from children count", (long)node.getChildren().size(), (long)this.iteratorSize(it));
        int index = 1;
        while (it.setPosition(index)) {
            NodePointer pchild = it.getNodePointer();
            Assert.assertEquals((String)"Wrong child", node.getChildren().get(index - 1), (Object)pchild.getNode());
            this.checkIterators(pchild);
            ++index;
        }
        it = p.attributeIterator(new QName(null, "*"));
        Assert.assertEquals((String)"Iterator count differs from attribute count", (long)node.getAttributes().size(), (long)this.iteratorSize(it));
        index = 1;
        while (it.setPosition(index)) {
            NodePointer pattr = it.getNodePointer();
            Assert.assertTrue((String)"Node pointer is no attribute", (boolean)pattr.isAttribute());
            Assert.assertTrue((String)"Wrong attribute name", (boolean)node.getAttributes().containsKey(pattr.getName().getName()));
            ++index;
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetValue() {
        this.pointer.setValue((Object)"newValue");
    }
}

